/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.utils.vocabulary;

import eu.dnetlib.data.search.utils.vocabulary.ISVocabulary;
import eu.dnetlib.data.search.utils.vocabulary.Vocabulary;
import eu.dnetlib.data.search.utils.vocabulary.VocabularyLoader;
import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.enabling.VocabularySearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ISVocabularyLoader
extends VocabularyLoader {
    private ResultSetFactory rsFactory = null;
    private ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> lookup = null;
    private static Logger logger = Logger.getLogger(ISVocabularyLoader.class);

    @Override
    public String getVocabularyXml(Vocabulary vocabulary, Locale locale) {
        logger.debug((Object)("Getting vocabulary with name " + vocabulary.getName() + " and locale " + locale));
        String localizedResourceName = ((ISVocabulary)vocabulary).getResourceName() + "_" + locale.getLanguage() + "_" + locale.getCountry();
        VocabularySearchCriteria criteria = new VocabularySearchCriteria();
        criteria.setName(localizedResourceName);
        ResultSet rs = null;
        String xml = null;
        try {
            rs = this.rsFactory.createResultSet(this.lookup.search((SearchCriteria)criteria));
            if (rs.size() > 0) {
                xml = (String)rs.getElements(1, 1).get(0);
            } else {
                logger.debug((Object)("The " + localizedResourceName + " does not exist in IS. Loading default vocabulary instead."));
                criteria.setName(((ISVocabulary)vocabulary).getResourceName());
                rs = this.rsFactory.createResultSet(this.lookup.search((SearchCriteria)criteria));
                if (rs.size() > 0) {
                    xml = (String)rs.getElements(1, 1).get(0);
                }
            }
        }
        catch (ISLookUpException ise) {
            logger.warn((Object)("Problem loading " + vocabulary.getName() + " from IS."), (Throwable)ise);
            return xml;
        }
        return xml;
    }

    public ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> getLookup() {
        return this.lookup;
    }

    public void setLookup(ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> lookup) {
        this.lookup = lookup;
    }

    public ResultSetFactory getRsFactory() {
        return this.rsFactory;
    }

    public void setRsFactory(ResultSetFactory rsFactory) {
        this.rsFactory = rsFactory;
    }
}

