/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.transform.formatter;

import eu.dnetlib.data.search.transform.FormatterException;
import eu.dnetlib.data.search.transform.formatter.Formatter;
import eu.dnetlib.data.search.transform.formatter.SimpleFormatter;
import eu.dnetlib.domain.data.SearchResult;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public class XSLTFormatter
extends SimpleFormatter
implements Formatter {
    private final String xslt;
    private final Logger logger = Logger.getLogger(XSLTFormatter.class);
    private Transformer xmlTransformer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSLTFormatter(String xslt) throws FormatterException {
        this.xslt = xslt;
        try {
            XSLTFormatter xSLTFormatter = this;
            synchronized (xSLTFormatter) {
                this.xmlTransformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(xslt))).newTransformer();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Error creating " + xslt + " transformer."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSLTFormatter(String xslt, String template) throws FormatterException {
        super(template);
        this.xslt = xslt;
        try {
            XSLTFormatter xSLTFormatter = this;
            synchronized (xSLTFormatter) {
                this.xmlTransformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(xslt))).newTransformer();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Error creating " + xslt + " transformer."), (Throwable)e);
        }
    }

    @Override
    public synchronized String format(SearchResult result) throws FormatterException {
        String input = super.format(result);
        StringWriter xmlResultResource = new StringWriter();
        try {
            this.logger.debug((Object)("The xsl to transform with " + this.xslt));
            this.logger.debug((Object)("before: " + result.getSearchResults()));
            this.xmlTransformer.transform(new StreamSource(new StringReader(input)), new StreamResult(xmlResultResource));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error transforming xml.", (Throwable)e);
            throw new FormatterException();
        }
        this.logger.debug((Object)("Transformer returns " + xmlResultResource.toString()));
        return xmlResultResource.toString();
    }

    public String getXslt() {
        return this.xslt;
    }
}

