/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.transform.formatter;

import eu.dnetlib.data.search.transform.FormatterException;
import eu.dnetlib.data.search.transform.formatter.Formatter;
import eu.dnetlib.data.search.transform.utils.VelocityUtil;
import eu.dnetlib.domain.data.SearchResult;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class SimpleFormatter
implements Formatter {
    private Transformer xmlTransformer = null;
    private StringWriter xmlResultResource = new StringWriter();
    private Template t = null;
    private final Logger logger = Logger.getLogger(SimpleFormatter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFormatter() throws FormatterException {
        StringWriter writer = null;
        InputStream inputStream = null;
        try {
            VelocityEngine ve = VelocityUtil.getEngine();
            String clean_xsl = "/eu/dnetlib/data/search/transform/config/omit-xml-declaration.xsl";
            this.t = ve.getTemplate("/eu/dnetlib/data/search/transform/config/format.vm");
            inputStream = this.getClass().getResource(clean_xsl).openStream();
            writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer);
            String xsl = writer.toString();
            SimpleFormatter simpleFormatter = this;
            synchronized (simpleFormatter) {
                this.xmlTransformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(xsl))).newTransformer();
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"Error while creating a velocity template.", (Throwable)e);
                throw new FormatterException("Error while creating a velocity template.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFormatter(String template) throws FormatterException {
        StringWriter writer = null;
        InputStream inputStream = null;
        this.logger.debug((Object)("Creating formatter with template " + template));
        try {
            VelocityEngine ve = VelocityUtil.getEngine();
            String clean_xsl = "/eu/dnetlib/data/search/transform/config/omit-xml-declaration.xsl";
            this.t = ve.getTemplate("/eu/dnetlib/data/search/transform/config/" + template);
            inputStream = this.getClass().getResource(clean_xsl).openStream();
            writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer);
            String xsl = writer.toString();
            SimpleFormatter simpleFormatter = this;
            synchronized (simpleFormatter) {
                this.xmlTransformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(xsl))).newTransformer();
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"Error while creating a velocity template.", (Throwable)e);
                throw new FormatterException("Error while creating a velocity template.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    @Override
    public String format(SearchResult result) throws FormatterException {
        VelocityContext context = null;
        try {
            context = new VelocityContext();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating a Velocity context.", (Throwable)e);
            FormatterException fe = new FormatterException("Error while creating a Velocity context.", e);
            throw fe;
        }
        try {
            context.put("page", (Object)result.getPage());
            context.put("query", (Object)StringEscapeUtils.escapeXml((String)result.getQuery()));
            context.put("size", (Object)result.getSize());
            context.put("total", (Object)result.getTotal());
            context.put("locale", (Object)result.getLocale());
            context.put("fields", (Object)result.getFields());
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z");
            context.put("currentDate", (Object)sdf.format(new Date()));
            if (result.getSearchResults() == null) {
                context.put("results", null);
            } else {
                context.put("results", this.clearDeclarations(result.getSearchResults()));
            }
            if (result.getBrowseResults() == null) {
                context.put("bresults", null);
            } else {
                context.put("bresults", this.clearDeclarations(result.getBrowseResults()));
            }
            StringWriter writer = new StringWriter();
            this.t.merge((Context)context, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            String text = "Error while formatting.";
            if (result == null) {
                text = text + " And result is null.";
            }
            this.logger.error((Object)text, (Throwable)e);
            FormatterException fe = new FormatterException("Error while formatting.", e);
            throw fe;
        }
    }

    public List<String> clearDeclarations(List<String> results) throws FormatterException {
        ArrayList<String> cleared = new ArrayList<String>();
        for (String result : results) {
            this.xmlResultResource.getBuffer().setLength(0);
            try {
                this.xmlTransformer.transform(new StreamSource(new StringReader(result)), new StreamResult(this.xmlResultResource));
            }
            catch (Exception e) {
                this.logger.warn((Object)"Error transforming xml.", (Throwable)e);
                throw new FormatterException();
            }
            cleared.add(this.xmlResultResource.getBuffer().toString());
        }
        return cleared;
    }
}

