/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.transform.config;

import eu.dnetlib.data.search.transform.ChainTransformer;
import eu.dnetlib.data.search.transform.FormatterRegistry;
import eu.dnetlib.data.search.transform.Transformer;
import eu.dnetlib.data.search.transform.TransformerRegistry;
import eu.dnetlib.data.search.transform.XsltTransformer;
import eu.dnetlib.data.search.transform.config.Configuration;
import eu.dnetlib.data.search.transform.config.FormatterConfiguration;
import eu.dnetlib.data.search.transform.config.SearchFactoryException;
import eu.dnetlib.data.search.transform.config.Transformation;
import eu.dnetlib.data.search.transform.config.XPathTrasformation;
import eu.dnetlib.data.search.transform.config.XSLTTransformation;
import eu.dnetlib.data.search.transform.formatter.Formatter;
import eu.dnetlib.data.search.transform.formatter.XSLTFormatter;
import eu.dnetlib.data.search.transform.utils.VelocityUtil;
import eu.dnetlib.data.search.utils.vocabulary.VocabularyManager;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class SearchRegistry
implements TransformerRegistry,
FormatterRegistry {
    private Logger logger = Logger.getLogger(this.getClass());
    private Configuration config = null;
    private VocabularyManager vocabularyManager = null;
    private Map<Locale, HashMap<String, Transformer>> transformers = new HashMap<Locale, HashMap<String, Transformer>>();
    private Map<String, Formatter> formatters = new HashMap<String, Formatter>();

    @Override
    public Transformer getTransformer(String name, Locale locale) {
        Transformer tx = null;
        if (name == null) {
            return null;
        }
        if (locale == null) {
            locale = this.config.getDefaultLocale();
        }
        try {
            if (this.transformers.get(locale) != null) {
                tx = this.transformers.get(locale).get(name);
            } else {
                this.logger.debug((Object)("Transofrmation map " + this.config.getTransformationsMap().keySet()));
                tx = this.createChainTransformer(name, locale, this.config.getTransformationsMap().get(name));
                HashMap<String, Transformer> map = new HashMap<String, Transformer>();
                map.put(name, tx);
                this.transformers.put(locale, map);
            }
            if (tx == null) {
                tx = this.createChainTransformer(name, locale, this.config.getTransformationsMap().get(name));
                this.transformers.get(locale).put(name, tx);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create transformer " + name, e);
        }
        return tx;
    }

    @Override
    public Formatter getFormatter(String name) {
        Formatter fm = this.formatters.get(name);
        try {
            if (fm == null) {
                FormatterConfiguration formatterConfiguration = this.config.getFormattersMap().get(name);
                String formatterXslt = formatterConfiguration.getXsl_file();
                String template = formatterConfiguration.getTemplate();
                this.logger.debug((Object)("Configuration for formatter: " + formatterXslt + ", " + template));
                if (formatterXslt == null) {
                    this.logger.error((Object)("Cannot create formatter " + name));
                    throw new IllegalArgumentException("Cannot create formatter " + name);
                }
                fm = template == null ? this.createFormatter(formatterXslt) : this.createFormatter(formatterXslt, template);
                this.formatters.put(name, fm);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot create formatter " + name));
            throw new IllegalArgumentException("Cannot create formatter " + name, e);
        }
        return fm;
    }

    private Transformer createChainTransformer(String name, Locale locale, List<Transformation> transformations) throws SearchFactoryException {
        ArrayList<XPathTrasformation> temp = new ArrayList<XPathTrasformation>();
        ArrayList<Transformer> forChaining = new ArrayList<Transformer>();
        for (Transformation tr : transformations) {
            if (tr instanceof XSLTTransformation) {
                try {
                    if (!temp.isEmpty()) {
                        forChaining.add(this.createTransformer("", locale, temp));
                    }
                    temp.clear();
                    forChaining.add(this.createTransformer("", (XSLTTransformation)tr));
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Error creating a transformer with name: " + name + " and locale: " + locale.getDisplayName()), (Throwable)e);
                    throw new SearchFactoryException();
                }
            }
            temp.add((XPathTrasformation)tr);
        }
        if (!temp.isEmpty()) {
            try {
                forChaining.add(this.createTransformer("", locale, temp));
            }
            catch (Exception e) {
                this.logger.warn((Object)("Error creating a transformer with name: " + name + " and locale: " + locale.getDisplayName()), (Throwable)e);
                throw new SearchFactoryException();
            }
        }
        return new ChainTransformer(name, forChaining);
    }

    private Transformer createTransformer(String transformerName, XSLTTransformation transformation) throws Exception {
        String xsl_file = transformation.getXslt();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(xsl_file);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer);
        String xsl = writer.toString();
        XsltTransformer OptimusPrime = new XsltTransformer(xsl);
        writer.close();
        IOUtils.closeQuietly((InputStream)inputStream);
        return OptimusPrime;
    }

    private Transformer createTransformer(String transformerName, Locale locale, List<XPathTrasformation> transformations) throws Exception {
        VelocityEngine ve = VelocityUtil.getEngine();
        Template t = ve.getTemplate("/eu/dnetlib/data/search/transform/config/velocity.vm");
        VelocityContext context = new VelocityContext();
        context.put("locale", (Object)locale);
        context.put("defLocale", (Object)this.config.getDefaultLocale());
        context.put("transformations", transformations);
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        XsltTransformer Megatron = new XsltTransformer(writer.toString());
        return Megatron;
    }

    private Formatter createFormatter(String xsl_file) throws Exception {
        this.logger.debug((Object)("Loading xslt " + xsl_file));
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(xsl_file);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer);
        String xsl = writer.toString();
        XSLTFormatter Cybertron = new XSLTFormatter(xsl);
        writer.close();
        IOUtils.closeQuietly((InputStream)inputStream);
        return Cybertron;
    }

    private Formatter createFormatter(String xsl_file, String template) throws Exception {
        this.logger.debug((Object)("Loading xslt " + xsl_file));
        this.logger.debug((Object)("Loading template " + template));
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(xsl_file);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer);
        String xsl = writer.toString();
        XSLTFormatter Cybertron = new XSLTFormatter(xsl, template);
        writer.close();
        IOUtils.closeQuietly((InputStream)inputStream);
        return Cybertron;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public void setVocabularyManager(VocabularyManager vocabularyManager) {
        this.vocabularyManager = vocabularyManager;
    }

    public VocabularyManager getVocabularyManager() {
        return this.vocabularyManager;
    }
}

