/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.solr;

import eu.dnetlib.data.search.solr.SolrResultSet;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SecureDriverResource;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.impl.CloudSolrServer;

public class SolrResultSetFactory
implements ResultSetFactory {
    private Logger logger = Logger.getLogger(this.getClass());
    private Map<String, CloudSolrServer> clients = new HashMap<String, CloudSolrServer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet<String> createResultSet(EPR epr) {
        try {
            CloudSolrServer solrClient = null;
            Map<String, CloudSolrServer> map = this.clients;
            synchronized (map) {
                solrClient = this.clients.get(epr.getAddress());
            }
            if (solrClient == null) {
                solrClient = new CloudSolrServer(epr.getAddress());
                this.clients.put(epr.getAddress(), solrClient);
            }
            return new SolrResultSet(epr, solrClient);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error creating solr client", (Throwable)e);
            return null;
        }
    }

    public <D> ResultSet<D> createResultSet(EPR epr, Class<D> resourceClass) {
        return this.createResultSet(epr);
    }

    public <D> ResultSet<D> createResultSet(ResultSet<?> rs, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }

    public <D extends SecureDriverResource> ResultSet<D> createSecurityAwareRS(EPR epr, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }
}

