/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.solr;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.functionality.index.cql.CqlTranslatorImpl;
import eu.dnetlib.functionality.index.cql.TranslatedQuery;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.z3950.zing.cql.CQLParseException;

public class SolrResultSet
implements ResultSet<String> {
    private Logger logger = Logger.getLogger(this.getClass());
    private EPR epr = null;
    private CloudSolrServer solrClient = null;
    private NamedList<String> queryOpts = new NamedList();
    int size = -1;
    List<FacetField> facetFields = null;

    public SolrResultSet(EPR epr, CloudSolrServer solrClient) throws IOException, CQLParseException {
        this.epr = epr;
        this.solrClient = solrClient;
        CqlTranslatorImpl translator = new CqlTranslatorImpl();
        String cqlQuery = epr.getParameter("query");
        String[] queryParts = cqlQuery.split("&groupby=");
        TranslatedQuery translatedQuery = translator.getTranslatedQuery(queryParts[0].replace("query=", ""));
        if (epr.getParameter("action").equals("lookup")) {
            this.queryOpts.add("q", (Object)translatedQuery.asLucene());
            this.queryOpts.add("fl", (Object)"__result");
            if (translatedQuery.getOptions() != null && translatedQuery.getOptions().getSort() != null) {
                this.queryOpts.add("sort", (Object)(translatedQuery.getOptions().getSort().getField() + " " + translatedQuery.getOptions().getSort().getMode()));
            }
        } else if (epr.getParameter("action").equals("browse")) {
            this.logger.debug((Object)("Browse query: " + translatedQuery.asLucene()));
            this.queryOpts.add("q", (Object)translatedQuery.asLucene());
            this.queryOpts.add("facet", (Object)"true");
            this.queryOpts.add("facet.mincount", (Object)"1");
            if (queryParts.length > 1) {
                this.queryOpts.add("facet.threads", (Object)(queryParts[1].split(",").length + ""));
                for (String field : queryParts[1].split(",")) {
                    this.queryOpts.add("facet.field", (Object)field);
                }
            }
        }
        this.queryOpts.add("shards.tolerant", (Object)"true");
        String layout = epr.getParameter("layout");
        String mdformat = epr.getParameter("mdformat");
        String interpretation = epr.getParameter("interpretation");
        solrClient.setDefaultCollection(mdformat + "-" + layout + "-" + interpretation);
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isAlive() {
        return true;
    }

    public void close() {
    }

    public int size() {
        if (this.size == -1) {
            try {
                this.size = this.getSize();
            }
            catch (SolrServerException sse) {
                this.logger.error((Object)"Fail to get size", (Throwable)sse);
            }
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize() throws SolrServerException {
        QueryResponse rsp = null;
        CloudSolrServer cloudSolrServer = this.solrClient;
        synchronized (cloudSolrServer) {
            rsp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
        }
        if (this.epr.getParameter("action").equals("lookup")) {
            return (int)rsp.getResults().getNumFound();
        }
        if (this.epr.getParameter("action").equals("browse")) {
            int max = -12;
            for (FacetField field : rsp.getFacetFields()) {
                if (field.getValueCount() <= max) continue;
                max = field.getValueCount();
            }
            return max;
        }
        return 0;
    }

    public List<String> getElements(int from, int to) {
        return this.get(from, to);
    }

    public List<String> get(int from, int to) {
        this.logger.debug((Object)("Getting records from " + from + "  to " + to));
        if ("lookup".equals(this.epr.getParameter("action"))) {
            return this.getDocumentResults(from, to);
        }
        if ("browse".equals(this.epr.getParameter("action"))) {
            return this.getBrowseResults(from, to);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBrowseResults(int from, int to) {
        ArrayList<String> res = new ArrayList<String>();
        if (this.facetFields == null) {
            try {
                QueryResponse rsp = null;
                CloudSolrServer cloudSolrServer = this.solrClient;
                synchronized (cloudSolrServer) {
                    rsp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
                }
                this.facetFields = rsp.getFacetFields();
            }
            catch (SolrServerException e) {
                e.printStackTrace();
            }
            for (int i = from - 1; i < to; ++i) {
                StringBuilder sb = new StringBuilder();
                sb.append("<row>");
                for (FacetField field : this.facetFields) {
                    if (field.getValueCount() <= i) continue;
                    sb.append("<groupresult field=\"").append(field.getName()).append("\">");
                    sb.append("<count>").append(((FacetField.Count)field.getValues().get(i)).getCount()).append("</count>");
                    sb.append("<value>").append(StringEscapeUtils.escapeXml((String)((FacetField.Count)field.getValues().get(i)).getName())).append("</value>");
                    sb.append("</groupresult>");
                }
                sb.append("</row>");
                res.add(sb.toString());
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDocumentResults(int from, int to) {
        try {
            QueryResponse rsp = null;
            NamedList extraOpts = new NamedList();
            extraOpts.add("start", (Object)(from - 1 + ""));
            extraOpts.add("rows", (Object)(to - from + 1 + ""));
            extraOpts.addAll(this.queryOpts);
            CloudSolrServer cloudSolrServer = this.solrClient;
            synchronized (cloudSolrServer) {
                rsp = this.solrClient.query(SolrParams.toSolrParams((NamedList)extraOpts));
            }
            SolrDocumentList docs = rsp.getResults();
            this.logger.debug((Object)("time: " + rsp.getElapsedTime()));
            this.logger.debug((Object)("found: " + docs.getNumFound()));
            ArrayList<String> res = new ArrayList<String>();
            for (int i = 0; i < to - from + 1; ++i) {
                String result = (String)((ArrayList)((SolrDocument)docs.get(i)).get((Object)"__result")).get(0);
                res.add(result);
            }
            return res;
        }
        catch (SolrServerException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, CQLParseException, SolrServerException {
        CloudSolrServer solrClient = new CloudSolrServer("beta.solr.openaire.eu:9983");
        NamedList queryOpts = new NamedList();
        TranslatedQuery translatedQuery = new CqlTranslatorImpl().getTranslatedQuery("oaftype=result sortBy resultdateofacceptance/sort.descending");
        queryOpts.add("q", (Object)translatedQuery.asLucene());
        System.out.println(translatedQuery.getOptions().getSort().getMode());
        System.out.println(translatedQuery.getOptions().getSort().getField());
        queryOpts.add("sort", (Object)(translatedQuery.getOptions().getSort().getField() + " " + translatedQuery.getOptions().getSort().getMode()));
        solrClient.setDefaultCollection("DMF-index-openaire");
        QueryResponse resp = null;
        CloudSolrServer cloudSolrServer = solrClient;
        synchronized (cloudSolrServer) {
            resp = solrClient.query(SolrParams.toSolrParams((NamedList)queryOpts));
        }
        System.out.println("time: " + resp.getElapsedTime());
        System.out.println("time: " + resp.getResults());
        System.out.println(resp.getFacetField("contextname").getValueCount());
        for (FacetField.Count count : resp.getFacetField("contextname").getValues()) {
            System.out.println(count.getName() + " : " + count.getCount());
        }
        int max = -12;
        for (FacetField field : resp.getFacetFields()) {
            if (field.getValueCount() <= max) continue;
            max = field.getValueCount();
        }
        System.out.println("max: " + max);
    }

    public EPR getEpr() {
        return this.epr;
    }
}

