/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.solr;

import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.data.search.solr.SolrIndexClient;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.List;
import org.apache.log4j.Logger;

public class SolrClientLocator
implements ServiceLocator<IndexService> {
    private Logger logger = Logger.getLogger(this.getClass());
    private SolrIndexClient indexClient = null;
    private ServiceLocator<ISLookUpService> lookUpServiceServiceLocator = null;
    private String interpretation = null;

    public IndexService getService() {
        if (this.indexClient == null) {
            this.indexClient = this.locateIndexService();
        }
        return this.indexClient;
    }

    private SolrIndexClient locateIndexService() {
        SolrIndexClient client = new SolrIndexClient();
        try {
            List urls = ((ISLookUpService)this.lookUpServiceServiceLocator.getService()).quickSearchProfile("for $x in //RESOURCE_PROFILE//PROTOCOL[./@name='solr'] return data($x/@address)");
            if (urls.size() <= 0) {
                throw new IllegalArgumentException("Could not locate an index service with a SOLR interface");
            }
            String url = this.chooseIndexService(urls);
            client.setSolrServerUrl(url);
            client.setInterpretation(this.interpretation);
        }
        catch (ISLookUpServiceException e) {
            this.logger.error((Object)"Error locating service", (Throwable)e);
        }
        return client;
    }

    private String chooseIndexService(List<String> urls) {
        return urls.get(0);
    }

    public ServiceLocator<ISLookUpService> getLookUpServiceServiceLocator() {
        return this.lookUpServiceServiceLocator;
    }

    public void setLookUpServiceServiceLocator(ServiceLocator<ISLookUpService> lookUpServiceServiceLocator) {
        this.lookUpServiceServiceLocator = lookUpServiceServiceLocator;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }
}

