/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.app.operator;

import eu.dnetlib.data.search.app.RankDocUtil;
import eu.dnetlib.data.search.app.operator.BasicOperator;
import eu.dnetlib.data.search.app.operator.Operator;
import eu.dnetlib.data.search.app.plan.Query;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MergeOperator
extends BasicOperator {
    private static final String EMPTY_RECORD = "__NULL__";
    private Operator[] inputs;
    List<List<String>> topPages;
    String[] topElements;
    int[] topPageIndexes;
    private int lastIndex;
    private static Logger logger = Logger.getLogger(MergeOperator.class);

    public MergeOperator(Operator[] inputs, Query query, int pageSize) {
        this(inputs, query, pageSize, 3, 300);
    }

    public MergeOperator(Operator[] inputs, Query query, int pageSize, int bufferSize, int timeout) {
        super("MergeOp", query, pageSize, bufferSize, timeout);
        this.inputs = inputs;
        int n = inputs.length;
        this.topPages = new ArrayList<List<String>>(n);
        this.topElements = new String[n];
        this.topPageIndexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.topPages.add(null);
            this.topElements[i] = null;
            this.topPageIndexes[i] = -1;
        }
        this.lastIndex = 0;
    }

    @Override
    public int initInput() {
        int i;
        int n = this.inputs.length;
        logger.debug((Object)"Merge Operator computes total number of elements...");
        int size = 0;
        for (i = 0; i < n; ++i) {
            size += this.inputs[i].getExactSize();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Merge Operator input has " + size + " elements"));
        }
        logger.debug((Object)"Merge Operator refreshes pages...");
        for (i = 0; i < n; ++i) {
            this.refreshPage(i);
        }
        logger.debug((Object)"Merge Operator inputs are ready");
        return size;
    }

    @Override
    public List<String> consumeInput(int start, int end) {
        ArrayList<String> page = new ArrayList<String>();
        if (start < this.getConsumedElements() + 1) {
            throw new UnsupportedOperationException("Cannot read backwards merge operator data");
        }
        if (start > this.getConsumedElements() + 1) {
            throw new UnsupportedOperationException("Cannot skip merge operator data");
        }
        for (int i = start; i <= end; ++i) {
            String element = this.selectNextRecord();
            if (element == null) {
                logger.warn((Object)"Merge Operator found null record");
                break;
            }
            if (element.equals(EMPTY_RECORD)) {
                logger.warn((Object)"Merge Operator found __NULL__ record");
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("element rank: " + RankDocUtil.parseRank(element)));
            }
            element = RankDocUtil.parseDmf(element);
            page.add(element);
        }
        return page;
    }

    private String selectNextRecord() {
        boolean found = false;
        int index = this.lastIndex;
        List<String> page = null;
        for (int i = 0; i < this.topPages.size(); ++i) {
            page = this.topPages.get(index = (index + 1) % this.topPages.size());
            if (page == null || page.size() <= 0) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        this.lastIndex = index;
        String element = this.topElements[index];
        if (this.topPageIndexes[index] == page.size() - 1) {
            this.refreshPage(index);
        } else {
            int n = index;
            this.topPageIndexes[n] = this.topPageIndexes[n] + 1;
            this.topElements[index] = page.get(this.topPageIndexes[index]);
        }
        return element;
    }

    private void refreshPage(int index) {
        List<String> page = this.inputs[index].getNextPage();
        while (page == null && this.inputs[index].isOpen()) {
            page = this.inputs[index].getNextPage();
        }
        if (logger.isDebugEnabled()) {
            if (page == null) {
                logger.debug((Object)("Merge Operator refreshes page index " + index + " with empty page"));
            } else {
                logger.debug((Object)("Merge Operator refreshes page index " + index + " with page of " + page.size() + " elements"));
            }
        }
        this.topPages.set(index, page);
        if (page == null || page.size() == 0) {
            this.topElements[index] = null;
            this.topPageIndexes[index] = -1;
        } else {
            this.topElements[index] = page.get(0);
            this.topPageIndexes[index] = 0;
        }
    }
}

