/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.app.operator;

import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.data.IndexServiceException;
import eu.dnetlib.data.search.app.operator.BasicOperator;
import eu.dnetlib.data.search.app.plan.Query;
import eu.dnetlib.domain.EPR;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import java.util.List;
import org.apache.log4j.Logger;

public class IndexOperator
extends BasicOperator {
    private static final String EMPTY_RECORD = "__NULL__";
    private static final String NOT_READY = "__NOT_READY__";
    private IndexService index;
    private ResultSet<String> resultSet;
    private ResultSetFactory rsFactory = null;
    private static Logger logger = Logger.getLogger(IndexOperator.class);

    public IndexOperator(IndexService index, Query query, int pageSize) {
        super("IndexOp", query, pageSize);
        this.index = index;
        this.resultSet = null;
    }

    @Override
    public int initInput() {
        EPR epr = null;
        try {
            logger.debug((Object)"Index Operator calls index...");
            epr = this.index.indexLookup("all", this.query.getText(), "dmf", "index");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Index response: " + epr));
            }
        }
        catch (IndexServiceException ise) {
            logger.warn((Object)"Index Operator failed to lookup index service ", (Throwable)ise);
        }
        if (epr == null) {
            logger.warn((Object)"Index Operator failed to lookup index service.");
            return -1;
        }
        logger.debug((Object)"Index Operator acesses result set...");
        this.resultSet = this.rsFactory.createResultSet(epr);
        if (this.resultSet == null) {
            logger.warn((Object)("Index Operator failed to get result set from: " + epr));
            return -1;
        }
        int size = this.resultSet.size();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Index Operator input has " + size + " elements"));
        }
        return size;
    }

    @Override
    public List<String> consumeInput(int start, int end) {
        List page = null;
        boolean found = false;
        block0: while (!found) {
            int n = this.getTotalElements();
            if (start < 1) {
                logger.warn((Object)("bad start element request: " + start));
                break;
            }
            if (end > n) {
                logger.warn((Object)("bad end element request: " + end));
                break;
            }
            if (start > end) {
                logger.warn((Object)("bad start/end element reuqest: " + start + "-" + end));
                break;
            }
            page = this.resultSet.getElements(start, end);
            if (page == null) break;
            found = true;
            for (int i = 0; i < page.size(); ++i) {
                if (((String)page.get(i)).equals("")) {
                    logger.warn((Object)"Found empty record, proceed!");
                }
                if (((String)page.get(i)).equals(EMPTY_RECORD)) {
                    found = false;
                    logger.warn((Object)"Found __NULL__ record, retry!");
                    continue block0;
                }
                if (!((String)page.get(i)).equals(NOT_READY)) continue;
                logger.debug((Object)"Found __NOT_READY__ record, retry!");
                found = false;
                continue block0;
            }
        }
        return page;
    }

    IndexService getIndex() {
        return this.index;
    }

    void setIndex(IndexService index) {
        this.index = index;
    }

    public ResultSetFactory getRsFactory() {
        return this.rsFactory;
    }

    public void setRsFactory(ResultSetFactory rsFactory) {
        this.rsFactory = rsFactory;
    }
}

