/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.app.operator;

import eu.dnetlib.data.search.app.operator.Operator;
import eu.dnetlib.data.search.app.plan.Query;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class BasicOperator
extends Thread
implements Operator {
    public static final int DEFAULT_BUFFER_SIZE = 3;
    public static final int DEFAULT_TIMEOUT_MS = 300;
    Query query;
    int pageSize;
    int timeout;
    private int totalElements;
    private int consumedElements;
    private BlockingQueue<List<String>> output;
    private Lock lock = new ReentrantLock();
    private Condition inputReady = this.lock.newCondition();
    private static Logger logger = Logger.getLogger(BasicOperator.class);

    public BasicOperator(String name, Query query, int pageSize) {
        this(name, query, pageSize, 3, 300);
    }

    public BasicOperator(String name, Query query, int pageSize, int bufferSize, int timeout) {
        super(name);
        this.query = query;
        this.pageSize = pageSize;
        this.timeout = timeout;
        this.output = new ArrayBlockingQueue<List<String>>(bufferSize, false);
        this.totalElements = -1;
        this.consumedElements = 0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " created"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " starts"));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Operator " + this.getName() + " initializes input"));
            }
            this.lock.lock();
            try {
                this.totalElements = this.initInput();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Operator " + this.getName() + " inputs " + this.totalElements + " elements"));
                }
                if (this.totalElements < 0) {
                    logger.warn((Object)("Operator " + this.getName() + " found no input"));
                    this.totalElements = 0;
                }
                this.inputReady.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Operator " + this.getName() + " consumes input"));
            }
            List<String> page = null;
            while (this.consumedElements < this.totalElements && !Thread.interrupted()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("consumed: " + this.consumedElements + " -- total: " + this.totalElements));
                }
                this.lock.lock();
                try {
                    if (page == null) {
                        page = this.consumeInput(this.consumedElements + 1, Math.min(this.consumedElements + this.pageSize, this.totalElements));
                    }
                    if (page == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Operator " + this.getName() + " finds empty input page and stops"));
                        }
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    this.output.add(page);
                    this.consumedElements += page.size();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Operator " + this.getName() + " new input page (" + page.size() + ") -- reached : " + this.consumedElements + " elements"));
                    }
                    page = null;
                }
                catch (IllegalStateException ise) {
                    BasicOperator.sleep(300L);
                    logger.debug((Object)"Cannot add page, retry...");
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"Unknown error", t);
            logger.warn((Object)"Clearing number of elements");
            this.totalElements = 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " exhausted input"));
        }
    }

    @Override
    public void cancel() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " is canceled"));
        }
        this.totalElements = 0;
        this.interrupt();
    }

    @Override
    public List<String> getNextPage() {
        List<String> page = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " is asked for new page"));
        }
        while (this.isOpen() && page == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\tstatus is " + (this.isOpen() ? "open" : "closed")));
            }
            try {
                page = this.output.poll(this.timeout, TimeUnit.MILLISECONDS);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("\tnew page is " + (page == null ? page : Integer.valueOf(page.size()))));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        boolean isOpen;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " is asked if open"));
        }
        if (this.output.size() > 0) {
            logger.debug((Object)"\telements in output: open");
            return true;
        }
        this.lock.lock();
        try {
            while (this.totalElements < 0) {
                logger.debug((Object)"\twait initialization...");
                this.inputReady.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
        boolean bl = isOpen = this.totalElements != this.consumedElements || this.output.size() > 0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " returns status: " + (isOpen ? "open" : "closed")));
        }
        return isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getExactSize() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " is asked for exact size"));
        }
        this.lock.lock();
        try {
            while (this.totalElements < 0) {
                logger.debug((Object)"\twait initialization...");
                this.inputReady.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operator " + this.getName() + " returns size: " + this.totalElements));
        }
        return this.totalElements;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    public int getConsumedElements() {
        return this.consumedElements;
    }

    public BlockingQueue<List<String>> getOutput() {
        return this.output;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTotalElements() {
        return this.totalElements;
    }

    public abstract int initInput();

    public abstract List<String> consumeInput(int var1, int var2);
}

