/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.app;

import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.data.IndexServiceException;
import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.common.rmi.UnimplementedException;
import eu.dnetlib.data.search.app.SearchServiceBlackboardHandler;
import eu.dnetlib.data.search.app.plan.FieldRewriteRule;
import eu.dnetlib.data.search.app.plan.QueryRewriteRule;
import eu.dnetlib.data.search.transform.Transformer;
import eu.dnetlib.data.search.transform.TransformerException;
import eu.dnetlib.data.search.transform.config.SearchRegistry;
import eu.dnetlib.data.search.transform.formatter.Formatter;
import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.data.FormattedSearchResult;
import eu.dnetlib.domain.data.SearchResult;
import eu.dnetlib.domain.data.SuggestiveResult;
import eu.dnetlib.domain.enabling.Notification;
import gr.uoa.di.driver.app.DriverServiceImpl;
import gr.uoa.di.driver.enabling.issn.NotificationListener;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.driver.util.ServiceLocator;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;

public class SearchServiceImpl
extends DriverServiceImpl
implements SearchService {
    private static Logger logger = Logger.getLogger(SearchServiceImpl.class);
    @Deprecated
    private static Logger tlogger = Logger.getLogger((String)"eu.dnetlib.data.search.app.Timer");
    private String mdFormat = "DMF";
    private String indexLayout = "index";
    private ServiceLocator<IndexService> indexLocator = null;
    private ServiceLocator<ISLookUpService> lookUpServiceServiceLocator = null;
    private ResultSetFactory rsFactory = null;
    private SearchRegistry transformerFactory = null;
    private List<QueryRewriteRule> queryRules = null;
    private Map<String, FieldRewriteRule> fieldRules = null;
    private boolean enableBrowseCache = false;
    private SearchServiceBlackboardHandler blackboardNotificationHandler = null;
    private CQLParser cqlParser = null;

    public void init() {
        super.init();
        String serviceId = this.getServiceEPR().getParameter("serviceId");
        this.subscribe(ActionType.UPDATE, ResourceType.SEARCHSERVICERESOURCETYPE, serviceId, "RESOURCE_PROFILE/BODY/BLACKBOARD/LAST_REQUEST", new NotificationListener(){

            public void processNotification(Notification notification) {
                SearchServiceImpl.this.blackboardNotificationHandler.notified(notification.getSubscriptionId(), notification.getTopic(), notification.getIsId(), notification.getMessage());
            }
        });
        try {
            String searchProfile = ((ISLookUpService)this.lookUpServiceServiceLocator.getService()).getResourceProfile(serviceId);
            if (searchProfile != null) {
                String profileMdFormat;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(searchProfile)));
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                XPathExpression searchMdFormatExpression = xpath.compile("//SERVICE_PROPERTIES/PROPERTY[@key='mdformat']");
                Node node = (Node)searchMdFormatExpression.evaluate(doc, XPathConstants.NODE);
                if (node != null && (profileMdFormat = node.getAttributes().getNamedItem("value").getTextContent()) != null) {
                    logger.debug((Object)("mdformat in properties " + this.mdFormat));
                    logger.info((Object)("Setting mdformat to '" + profileMdFormat + "'"));
                    this.mdFormat = profileMdFormat;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Fail to load search service profile with id " + serviceId + " from IS."), (Throwable)e);
        }
    }

    public SuggestiveResult suggestiveSearch(String query) throws SearchServiceException {
        throw new UnimplementedException();
    }

    private String getCorrectLocale(String givenLocaleName) {
        String correctLocale = null;
        if (givenLocaleName == null) {
            return this.transformerFactory.getConfig().getDefaultLocale().getLanguage() + "_" + this.transformerFactory.getConfig().getDefaultLocale().getCountry();
        }
        correctLocale = givenLocaleName;
        StringTokenizer tokenizer = new StringTokenizer(correctLocale, "_");
        Locale requestLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
        if (requestLocale == null || !this.transformerFactory.getConfig().getLocales().contains(requestLocale)) {
            correctLocale = this.transformerFactory.getConfig().getDefaultLocale().getLanguage() + "_" + this.transformerFactory.getConfig().getDefaultLocale().getCountry();
        }
        return correctLocale;
    }

    public SearchResult search(String text, String transformer, String locale, int page, int size) throws SearchServiceException {
        logger.debug((Object)("Received Query: " + text));
        tlogger.debug((Object)("Received query " + text));
        IndexService index = (IndexService)this.getIndexLocator().getService();
        EPR epr = null;
        String query = this.rewrite(text);
        ArrayList<String> searchResults = null;
        try {
            long time = System.currentTimeMillis();
            this.cqlParser = new CQLParser();
            query = this.cqlParser.parse(query).toCQL();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("index lookup (all, query=" + query + ", " + this.mdFormat + ", index)"));
            }
            epr = index.indexLookup("all", query, this.mdFormat, this.indexLayout);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("epr = " + epr));
            }
            time = System.currentTimeMillis() - time;
            logger.debug((Object)("index query lasted " + time + " msec"));
            tlogger.debug((Object)("Got index response for query " + query));
        }
        catch (IndexServiceException ise) {
            logger.error((Object)"Error calling index.", (Throwable)ise);
            throw new SearchServiceException("Error calling index.");
        }
        catch (CQLParseException cqle) {
            logger.error((Object)"Bad CQL query.", (Throwable)cqle);
            throw new SearchServiceException("Error calling index.");
        }
        catch (IOException ioe) {
            logger.error((Object)"Bad CQL query.", (Throwable)ioe);
            throw new SearchServiceException("Error calling index.");
        }
        if (epr == null) {
            throw new SearchServiceException("Index returned null result set id.");
        }
        String correctLocale = this.getCorrectLocale(locale);
        StringTokenizer tokenizer = new StringTokenizer(correctLocale, "_");
        Locale requestLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
        ResultSet rs = this.rsFactory.createResultSet(epr);
        try {
            int rsSize = rs.size();
            int from = (page - 1) * size + 1;
            int to = page * size < rsSize ? page * size : rsSize;
            List xmls = rs.getElements(from, to);
            searchResults = new ArrayList<String>();
            Transformer tr = this.transformerFactory.getTransformer(transformer, requestLocale);
            if (tr != null) {
                for (String xml : xmls) {
                    searchResults.add(tr.transform(xml));
                }
            } else {
                for (String xml : xmls) {
                    searchResults.add(xml);
                }
            }
        }
        catch (TransformerException te) {
            logger.error((Object)"Error transforming search results.", (Throwable)te);
            throw new SearchServiceException("Error transforming search results.", (Throwable)te);
        }
        logger.debug((Object)("Search results for query " + query + " created."));
        logger.debug((Object)("Returned results for query " + query));
        return new SearchResult(query, correctLocale, rs.size(), page, size, searchResults);
    }

    public SearchResult refine(String text, String transformer, String locale, Collection<String> fields) throws SearchServiceException {
        IndexService index = (IndexService)this.getIndexLocator().getService();
        EPR epr = null;
        String query = this.rewrite(text);
        ArrayList<String> browseResults = null;
        ResultSet rs = null;
        try {
            long time = System.currentTimeMillis();
            logger.debug((Object)("Refine query is: '" + query + "'"));
            this.cqlParser = new CQLParser();
            query = this.cqlParser.parse(query).toCQL();
            logger.debug((Object)("The refine query " + query));
            StringBuffer buffer = new StringBuffer();
            buffer.append("query=").append(query).append("&groupby=");
            Iterator<String> iter = fields.iterator();
            while (iter.hasNext()) {
                String field = iter.next();
                buffer.append(field);
                if (!iter.hasNext()) continue;
                buffer.append(",");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The refine query " + query));
                logger.debug((Object)("index refine (" + buffer.toString() + ", all, " + this.mdFormat + ", index)"));
            }
            epr = index.getBrowsingStatistics(buffer.toString(), "all", this.mdFormat, this.indexLayout);
            time = System.currentTimeMillis() - time;
            logger.debug((Object)("index query lasted " + time + " msec"));
        }
        catch (CQLParseException cqle) {
            logger.error((Object)"Bad CQL query.", (Throwable)cqle);
            throw new SearchServiceException("Error calling index.");
        }
        catch (IndexServiceException ise) {
            logger.error((Object)"Error getting refine results.", (Throwable)ise);
            throw new SearchServiceException("Error getting refine results.", (Throwable)ise);
        }
        catch (IOException ioe) {
            logger.error((Object)"Bad CQL query.", (Throwable)ioe);
            throw new SearchServiceException("Error calling index.");
        }
        if (epr == null) {
            throw new SearchServiceException("Index returned null result set id.");
        }
        String correctLocale = this.getCorrectLocale(locale);
        StringTokenizer tokenizer = new StringTokenizer(correctLocale, "_");
        Locale requestLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
        try {
            rs = this.rsFactory.createResultSet(epr);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("EPR : " + epr.getEpr()));
            }
            List list = rs.getElements(1, rs.size());
            logger.debug((Object)("record list size " + list.size()));
            Transformer tr = this.transformerFactory.getTransformer(transformer, requestLocale);
            browseResults = new ArrayList<String>();
            for (String row : list) {
                browseResults.add(tr.transform(row));
            }
        }
        catch (TransformerException te) {
            logger.error((Object)"Error transforming refine results.", (Throwable)te);
            throw new SearchServiceException("Error transforming refine results.", (Throwable)te);
        }
        return new SearchResult(query, correctLocale, fields, browseResults);
    }

    public SearchResult searchNrefine(String text, String searchTransformer, String browseTransformer, String locale, int page, int size, Collection<String> fields) throws SearchServiceException {
        logger.info((Object)("Received Query: " + text));
        IndexService index = (IndexService)this.getIndexLocator().getService();
        EPR epr = null;
        String query = this.rewrite(text);
        String correctLocale = this.getCorrectLocale(locale);
        StringTokenizer tokenizer = new StringTokenizer(correctLocale, "_");
        Locale requestLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
        ArrayList<String> searchResults = null;
        try {
            long time = System.currentTimeMillis();
            this.cqlParser = new CQLParser();
            query = this.cqlParser.parse(query).toCQL();
            logger.debug((Object)("cqlParser returned query: " + query));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("index lookup (all, query=" + query + ", " + this.mdFormat + ", index)"));
            }
            epr = index.indexLookup("all", query, this.mdFormat, "index");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("epr = " + epr));
            }
            time = System.currentTimeMillis() - time;
            logger.debug((Object)("index query lasted " + time + " msec"));
        }
        catch (IndexServiceException ise) {
            logger.error((Object)"Error calling index.", (Throwable)ise);
            throw new SearchServiceException("Error calling index.");
        }
        catch (CQLParseException cqle) {
            logger.error((Object)"Bad CQL query.", (Throwable)cqle);
            throw new SearchServiceException("Error calling index.");
        }
        catch (IOException ioe) {
            logger.error((Object)"Bad CQL query.", (Throwable)ioe);
            throw new SearchServiceException("Error calling index.");
        }
        if (epr == null) {
            throw new SearchServiceException("Index returned null result set id.");
        }
        int rsSize = -1;
        ResultSet rs = this.rsFactory.createResultSet(epr);
        try {
            rsSize = rs.size();
            int from = (page - 1) * size + 1;
            int to = page * size < rsSize ? page * size : rsSize;
            List xmls = rs.getElements(from, to);
            Transformer tr = this.transformerFactory.getTransformer(searchTransformer, requestLocale);
            searchResults = new ArrayList<String>();
            for (String xml : xmls) {
                searchResults.add(tr.transform(xml));
            }
        }
        catch (TransformerException te) {
            logger.error((Object)"Error transforming search results.", (Throwable)te);
            throw new SearchServiceException("Error transforming search results.", (Throwable)te);
        }
        ArrayList<String> browseResults = null;
        try {
            long time = System.currentTimeMillis();
            this.cqlParser = new CQLParser();
            query = this.cqlParser.parse(query).toCQL();
            StringBuffer buffer = new StringBuffer();
            buffer.append("query=").append(query).append("&groupby=");
            Iterator<String> iter = fields.iterator();
            while (iter.hasNext()) {
                String field = iter.next();
                buffer.append(field);
                if (!iter.hasNext()) continue;
                buffer.append(",");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("index refine (" + buffer.toString() + ", all, " + this.mdFormat + ", index)"));
            }
            epr = index.getBrowsingStatistics(buffer.toString(), "all", this.mdFormat, "index");
            time = System.currentTimeMillis() - time;
            logger.debug((Object)("index query lasted " + time + " msec"));
        }
        catch (CQLParseException cqle) {
            logger.error((Object)"Bad CQL query.", (Throwable)cqle);
            throw new SearchServiceException("Error calling index.");
        }
        catch (IOException ioe) {
            logger.error((Object)"Bad CQL query.", (Throwable)ioe);
            throw new SearchServiceException("Error calling index.");
        }
        catch (IndexServiceException ise) {
            logger.error((Object)"Error getting refine results.", (Throwable)ise);
            throw new SearchServiceException("Error getting refine results.", (Throwable)ise);
        }
        if (epr == null) {
            throw new SearchServiceException("Index returned null result set id.");
        }
        try {
            rs = this.rsFactory.createResultSet(epr);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("EPR : " + epr.getEpr()));
            }
            List list = rs.getElements(1, rs.size());
            logger.debug((Object)("record list size " + list.size()));
            Transformer tr = this.transformerFactory.getTransformer(browseTransformer, requestLocale);
            browseResults = new ArrayList<String>();
            for (String row : list) {
                browseResults.add(tr.transform(row));
            }
        }
        catch (TransformerException te) {
            logger.error((Object)"Error transforming refine results.", (Throwable)te);
            throw new SearchServiceException("Error transforming refine results.", (Throwable)te);
        }
        return new SearchResult(query, correctLocale, rsSize, page, size, searchResults, browseResults, fields);
    }

    public List<String> getSearchResultsFromIndex() {
        return null;
    }

    public List<String> getRefineResultsFromIndex() {
        return null;
    }

    public FormattedSearchResult search(String queryText, String transformer, String format, String locale, int page, int size) throws SearchServiceException {
        FormattedSearchResult formattedSearchResult = null;
        SearchResult searchResult = this.search(queryText, transformer, locale, page, size);
        Formatter formatter = this.transformerFactory.getFormatter(format);
        if (formatter == null) {
            logger.error((Object)("Error formatting search results. " + format + " formatter does not exist."));
            throw new SearchServiceException("Error formatting search results. " + format + " formatter does not exist.");
        }
        try {
            formattedSearchResult = new FormattedSearchResult(formatter.format(searchResult), searchResult.getTotal());
            logger.debug((Object)("Returning formatted result: page " + page + ", size: " + size + " of total: " + searchResult.getTotal()));
        }
        catch (Exception e) {
            logger.error((Object)"Error formatting search results.", (Throwable)e);
        }
        return formattedSearchResult;
    }

    public FormattedSearchResult refine(String queryText, String refineTransformer, String format, String locale, Collection<String> fields) throws SearchServiceException {
        FormattedSearchResult formattedSearchResult = null;
        SearchResult searchResult = this.refine(queryText, refineTransformer, locale, fields);
        Formatter formatter = this.transformerFactory.getFormatter(format);
        if (formatter == null) {
            logger.error((Object)("Error formatting refine results. " + format + " formatter does not exist."));
            throw new SearchServiceException("Error formatting refine results. " + format + " formatter does not exist.");
        }
        try {
            formattedSearchResult = new FormattedSearchResult(formatter.format(searchResult), searchResult.getTotal());
        }
        catch (Exception e) {
            logger.error((Object)"Error formatting refine results.", (Throwable)e);
        }
        return formattedSearchResult;
    }

    public FormattedSearchResult searchNrefine(String queryText, String searchTransformer, String refineTransformer, String format, String locale, int page, int size, Collection<String> fields) throws SearchServiceException {
        FormattedSearchResult formattedSearchResult = null;
        SearchResult searchResult = this.searchNrefine(queryText, searchTransformer, refineTransformer, locale, page, size, fields);
        Formatter formatter = this.transformerFactory.getFormatter(format);
        if (formatter == null) {
            logger.error((Object)("Error formating search and refine results. " + format + " formatter does not exist."));
            throw new SearchServiceException("Error formating search and refine results. " + format + " formatter does not exist.");
        }
        try {
            formattedSearchResult = new FormattedSearchResult(formatter.format(searchResult), searchResult.getTotal());
        }
        catch (Exception e) {
            logger.error((Object)"Error formating search results.", (Throwable)e);
        }
        return formattedSearchResult;
    }

    private String rewrite(String query) {
        if (this.queryRules != null) {
            for (QueryRewriteRule queryRule : this.queryRules) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Apply rule " + query));
                }
                query = queryRule.apply(query);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Rewritten query is " + query));
            }
        }
        return query;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public ServiceLocator<IndexService> getIndexLocator() {
        return this.indexLocator;
    }

    public void setIndexLocator(ServiceLocator<IndexService> indexLocator) {
        this.indexLocator = indexLocator;
    }

    public ResultSetFactory getRsFactory() {
        return this.rsFactory;
    }

    public void setRsFactory(ResultSetFactory rsFactory) {
        this.rsFactory = rsFactory;
    }

    public Collection<FieldRewriteRule> getFieldRules() {
        return this.fieldRules.values();
    }

    public void setFieldRules(Collection<FieldRewriteRule> fieldRules) {
        this.fieldRules = new HashMap<String, FieldRewriteRule>();
        for (FieldRewriteRule rule : fieldRules) {
            String key = rule.getFieldName();
            if (this.fieldRules.containsKey(key)) {
                logger.warn((Object)("Multiple rules for field " + key));
                logger.warn((Object)("Keeping last rule " + rule.getName()));
            }
            this.fieldRules.put(key, rule);
        }
    }

    public List<QueryRewriteRule> getQueryRules() {
        return this.queryRules;
    }

    public void setQueryRules(List<QueryRewriteRule> queryRules) {
        this.queryRules = queryRules;
    }

    public boolean isEnableBrowseCache() {
        return this.enableBrowseCache;
    }

    public void setEnableBrowseCache(boolean enableBrowseCache) {
        this.enableBrowseCache = enableBrowseCache;
    }

    public SearchRegistry getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(SearchRegistry transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public String getIndexLayout() {
        return this.indexLayout;
    }

    public void setIndexLayout(String indexLayout) {
        this.indexLayout = indexLayout;
    }

    public SearchServiceBlackboardHandler getBlackboardNotificationHandler() {
        return this.blackboardNotificationHandler;
    }

    public void setBlackboardNotificationHandler(SearchServiceBlackboardHandler blackboardNotificationHandler) {
        this.blackboardNotificationHandler = blackboardNotificationHandler;
    }

    public void setLookUpServiceServiceLocator(ServiceLocator<ISLookUpService> lookUpServiceServiceLocator) {
        this.lookUpServiceServiceLocator = lookUpServiceServiceLocator;
    }
}

