/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.app;

import eu.dnetlib.data.search.app.DriverNamespaceContext;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RankDocUtil {
    private static Logger logger = Logger.getLogger(RankDocUtil.class);
    private static XPathExpression RANK_EXPRESSION = null;
    private static XPathExpression DMF_EXPRESSION = null;
    private static Transformer TRANSFORMER = null;

    public static synchronized String parseDmf(String record) {
        String dmf = null;
        try {
            Node node = (Node)DMF_EXPRESSION.evaluate(new InputSource(new StringReader(record)), XPathConstants.NODE);
            StreamResult result = new StreamResult(new StringWriter());
            TRANSFORMER.transform(new DOMSource(node), result);
            dmf = result.getWriter().toString();
        }
        catch (XPathExpressionException xpee) {
            logger.error((Object)"Cannot parse dmf", (Throwable)xpee);
        }
        catch (TransformerException te) {
            logger.error((Object)"Cannot parse dmf", (Throwable)te);
        }
        return dmf;
    }

    public static synchronized double parseRank(String record) {
        double rank = 0.0;
        try {
            String string = (String)RANK_EXPRESSION.evaluate(new InputSource(new StringReader(record)), XPathConstants.STRING);
            rank = Double.parseDouble(string);
        }
        catch (XPathExpressionException xpee) {
            logger.error((Object)"Cannot parse rank", (Throwable)xpee);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)"Cannot parse rank", (Throwable)nfe);
        }
        return rank;
    }

    static {
        try {
            TRANSFORMER = TransformerFactory.newInstance().newTransformer();
            TRANSFORMER.setOutputProperty("indent", "yes");
            TRANSFORMER.setOutputProperty("encoding", "UTF-8");
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException("Failed to build doc transformer.", tce);
        }
        catch (TransformerFactoryConfigurationError tfe) {
            throw new RuntimeException("Failed to build doc transformer.", tfe);
        }
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new DriverNamespaceContext());
            RANK_EXPRESSION = xpath.compile("/record/@rank");
            DMF_EXPRESSION = xpath.compile("/record/result");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to build xpath expression.", e);
        }
    }
}

