package gr.uoa.di.driver.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBException;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.CommunityRegistration;
import eu.dnetlib.domain.functionality.SavedQuery;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.domain.functionality.UserProfileSearchCriteria;
import eu.dnetlib.domain.functionality.UserStore;
import gr.uoa.di.driver.xml.userprofile.COMMUNITYREGISTRATIONType;
import gr.uoa.di.driver.xml.userprofile.FILTERType;
import gr.uoa.di.driver.xml.userprofile.ObjectFactory;
import gr.uoa.di.driver.xml.userprofile.QUERYType.COLLECTIONID;
import gr.uoa.di.driver.xml.userprofile.QUERYType.COMMUNITYID;
import gr.uoa.di.driver.xml.userprofile.RESOURCEPROFILE;
import gr.uoa.di.driver.xml.userprofile.SAVEDQUERYType;

public class UserProfileXmlConverter extends AbstractConverter<UserProfile> implements
		ResourceToXmlConverter<UserProfile> {

	private ObjectFactory of = new ObjectFactory();
	private static Logger logger = Logger
			.getLogger(UserProfileXmlConverter.class);

	public UserProfileXmlConverter() throws JAXBException {
		super(RESOURCEPROFILE.class);
	}

	public String ObjectToXml(UserProfile user) throws JAXBException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		RESOURCEPROFILE profile = of.createRESOURCEPROFILE();

		// header info
		profile.setHEADER(of.createHEADERType());

		profile.getHEADER().setDATEOFCREATION(of.createDATEOFCREATIONType());
		profile.getHEADER().setRESOURCEIDENTIFIER(
				of.createRESOURCEIDENTIFIERType());
		profile.getHEADER().setRESOURCEKIND(of.createRESOURCEKINDType());
		profile.getHEADER().setRESOURCETYPE(of.createRESOURCETYPEType());
		profile.getHEADER().setRESOURCEURI(of.createRESOURCEURIType());

		profile.getHEADER().getRESOURCETYPE().setValue(user.getResourceType());
		profile.getHEADER().getRESOURCEKIND().setValue(user.getResourceKind());

		if (user.getDateOfCreation() != null)
			profile.getHEADER().getDATEOFCREATION().setValue(
					ConversionUtils
							.DateToString(user.getDateOfCreation()));
		else
			profile.getHEADER().getDATEOFCREATION().setValue("");

		if (user.getResourceId() != null)
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue(
					user.getResourceId());
		else
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
		
		if (user.getResourceUri() != null)
			profile.getHEADER().getRESOURCEURI().setValue(
					user.getResourceUri());
		else
			profile.getHEADER().getRESOURCEURI().setValue("");
		
		profile.setBODY(of.createBODYType());
		profile.getBODY().setSTATUS("");
		profile.getBODY().setSECURITYPARAMETERS(
				of.createSECURITYPARAMETERSType());
		// TODO security parameters
		profile.getBODY().getSECURITYPARAMETERS().setSECURITYPARAMETER("value");
		profile.getBODY().setCONFIGURATION(of.createCONFIGURATIONType());

		// general info
		profile.getBODY().getCONFIGURATION().setPERSONALINFO(
				of.createPERSONALINFOType());

		profile.getBODY().getCONFIGURATION().getPERSONALINFO().setEMAIL(
				of.createPERSONALINFOTypeEMAIL());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO().setINSTITUTION(
				of.createPERSONALINFOTypeINSTITUTION());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO().setFIRSTNAME(
				of.createPERSONALINFOTypeFIRSTNAME());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO().setLASTNAME(
				of.createPERSONALINFOTypeLASTNAME());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO().setACTIVATIONID(
				of.createPERSONALINFOTypeACTIVATIONID());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO().setACTIVE(
				of.createPERSONALINFOTypeACTIVE());

		profile.getBODY().getCONFIGURATION().getPERSONALINFO().getEMAIL()
				.setValue(user.getEmail());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO().getINSTITUTION()
				.setValue(user.getInstitution());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO().getFIRSTNAME()
				.setValue(user.getFirstname());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO().getLASTNAME()
				.setValue(user.getLastname());
		profile.getBODY().getCONFIGURATION().getPERSONALINFO()
				.getACTIVATIONID().setValue(user.getActivationId());

		profile.getBODY().getCONFIGURATION().getPERSONALINFO().getACTIVE()
				.setValue(user.getActive());

		// recommendations
		profile.getBODY().getCONFIGURATION().setRECOMMENDATION(
				of.createRECOMMENDATIONType());
		profile.getBODY().getCONFIGURATION().getRECOMMENDATION()
				.setRECOMMENDATIONS(of.createRECOMMENDATIONSType());

		if (user.getLastNotificationDate() != null)
			profile.getBODY().getCONFIGURATION().getRECOMMENDATION()
					.setLASTNOTIFICATION(
							ConversionUtils.DateToString(user
									.getLastNotificationDate()));
		if (user.getRecommendationPeriod() != null)
			profile.getBODY().getCONFIGURATION().getRECOMMENDATION().setPERIOD(
					user.getRecommendationPeriod());
		if (user.getRecommendationSendEmail() != null)
			profile.getBODY().getCONFIGURATION().getRECOMMENDATION()
					.setSENDEMAIL(user.getRecommendationSendEmail());

		for (String id : user.getRecommendations()) {
			profile.getBODY().getCONFIGURATION().getRECOMMENDATION()
					.getRECOMMENDATIONS().getRECOMMENDATIONID().add(id);
		}

		// communities
		profile.getBODY().getCONFIGURATION().setCOMMUNITIES(
				of.createCOMMUNITIESType());

		for (CommunityRegistration commReg : user.getCommunities()) {
			COMMUNITYREGISTRATIONType regType = of
					.createCOMMUNITYREGISTRATIONType();

			regType.setAlertOnChange(commReg.isAlertOnChange());
			regType.setCommunityId(commReg.getCommunityId());
			regType.setInsertInQueries(commReg.getIncludeInQueries());

			profile.getBODY().getCONFIGURATION().getCOMMUNITIES()
					.getCOMMUNITYREGISTRATION().add(regType);
		}

		// documents
		if (user.getDocumentIds().size() != 0) {
			profile.getBODY().getCONFIGURATION().setDOCUMENTS(
					of.createDOCUMENTSType());

			for (String documentId : user.getDocumentIds())
				profile.getBODY().getCONFIGURATION().getDOCUMENTS()
						.getDOCUMENTID().add(documentId);
		}

		// user store
		if (user.getStore() != null) {

			profile.getBODY().getCONFIGURATION().setUSERSTORE(
					of.createSTOREType());
			profile.getBODY().getCONFIGURATION().getUSERSTORE().setServiceURL(
					user.getStore().getStoreServiceURL());
			profile.getBODY().getCONFIGURATION().getUSERSTORE().setStoreID(
					user.getStore().getStoreID());

		}

		// user image
		if (user.getUserPhotoID() != null)
			profile.getBODY().getCONFIGURATION().setUserImageID(
					user.getUserPhotoID());

		// FILTER

		if (user.getFilter() != null) {

			FILTERType filter = of.createFILTERType();
			filter.setQuery(of.createSAVEDQUERYType());
			filter.getQuery().setAlertOnChange(
					user.getFilter().isAlertOnChange());
			filter.getQuery().getHashValue().addAll(
					user.getFilter().getHashValues());

			filter.getQuery().setQuery(of.createQUERYType());
			filter.getQuery().getQuery().setCQL(of.createQUERYTypeCQL());

			filter.getQuery().getQuery().getCQL().setValue(
					user.getFilter().getCqlText());

			if (user.getFilter().getRefineText() != null) {

				filter.getQuery().getQuery().setREFINE(
						of.createQUERYTypeREFINE());
				filter.getQuery().getQuery().getREFINE().setValue(
						user.getFilter().getRefineText());

			}

			if (user.getFilter().getCollectionIds() != null) {
				for (String id : user.getFilter().getCollectionIds()) {
					COLLECTIONID colId = of.createQUERYTypeCOLLECTIONID();

					colId.setCollectionId(id);

					filter.getQuery().getQuery().getCOLLECTIONID().add(colId);
				}
			}

			if (user.getFilter().getCommunityIds() != null) {
				for (String id : user.getFilter().getCommunityIds()) {
					COMMUNITYID comId = of.createQUERYTypeCOMMUNITYID();

					comId.setCommunityId(id);

					filter.getQuery().getQuery().getCOMMUNITYID().add(comId);
				}
			}

			profile.getBODY().getCONFIGURATION().setFILTER(filter);

		}

		// saved queries
		for (SavedQuery sQuery : user.getSavedQueries()) {

			SAVEDQUERYType savedQuery = of.createSAVEDQUERYType();

			savedQuery.setQuery(of.createQUERYType());
			savedQuery.getQuery().setCQL(of.createQUERYTypeCQL());

			savedQuery.setAlertOnChange(sQuery.isAlertOnChange());
			savedQuery.getHashValue().addAll(sQuery.getHashValues());

			savedQuery.getQuery().getCQL().setValue(sQuery.getCqlText());

			// added for REFINE
			if (sQuery.getRefineText() != null) {
				savedQuery.getQuery().setREFINE(of.createQUERYTypeREFINE());
				savedQuery.getQuery().getREFINE().setValue(
						sQuery.getRefineText());

			}

			if (sQuery.getCollectionIds() != null) {
				for (String id : sQuery.getCollectionIds()) {
					COLLECTIONID colId = of.createQUERYTypeCOLLECTIONID();

					colId.setCollectionId(id);

					savedQuery.getQuery().getCOLLECTIONID().add(colId);
				}
			}

			if (sQuery.getCommunityIds() != null) {
				for (String id : sQuery.getCommunityIds()) {
					COMMUNITYID comId = of.createQUERYTypeCOMMUNITYID();

					comId.setCommunityId(id);

					savedQuery.getQuery().getCOMMUNITYID().add(comId);
				}
			}

			profile.getBODY().getCONFIGURATION().getSAVEDQUERIES().add(
					savedQuery);
		}

		this.getMarshaller().marshal(profile, baos);

		return baos.toString();
	}

	public UserProfile XmlToObject(String xml) throws JAXBException {
		UserProfile user = new UserProfile();
		RESOURCEPROFILE profile = (RESOURCEPROFILE) this.getUnmarshaller()
				.unmarshal(new ByteArrayInputStream(xml.getBytes()));

		// header info
		user.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER()
				.getValue());

		if (profile.getHEADER().getDATEOFCREATION().getValue() != null) {
			user.setDateOfCreation(ConversionUtils.parseDate(profile
					.getHEADER().getDATEOFCREATION().getValue()));
			user.setRegistrationDate(ConversionUtils.parseDate(profile
					.getHEADER().getDATEOFCREATION().getValue()));
		}
		user.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());
		user.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
		user.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());

		// general info
		user.setEmail(profile.getBODY().getCONFIGURATION().getPERSONALINFO()
				.getEMAIL().getValue());
		user.setFirstname(profile.getBODY().getCONFIGURATION()
				.getPERSONALINFO().getFIRSTNAME().getValue());
		user.setLastname(profile.getBODY().getCONFIGURATION().getPERSONALINFO()
				.getLASTNAME().getValue());
		user.setInstitution(profile.getBODY().getCONFIGURATION()
				.getPERSONALINFO().getINSTITUTION().getValue());
		user.setActivationId(profile.getBODY().getCONFIGURATION()
				.getPERSONALINFO().getACTIVATIONID().getValue());

		if (profile.getBODY().getCONFIGURATION().getPERSONALINFO().getACTIVE() != null)
			user.setActive(profile.getBODY().getCONFIGURATION()
					.getPERSONALINFO().getACTIVE().isValue());

		// image ID
		if (profile.getBODY().getCONFIGURATION().getUserImageID() != null)
			user.setUserPhotoID(profile.getBODY().getCONFIGURATION()
					.getUserImageID());

		// recommendations
		List<String> ids = profile.getBODY().getCONFIGURATION()
				.getRECOMMENDATION().getRECOMMENDATIONS().getRECOMMENDATIONID();

		user.setRecommendationPeriod(profile.getBODY().getCONFIGURATION()
				.getRECOMMENDATION().getPERIOD());
		user.setRecommendationSendEmail(profile.getBODY().getCONFIGURATION()
				.getRECOMMENDATION().isSENDEMAIL());
		if (profile.getBODY().getCONFIGURATION().getRECOMMENDATION()
				.getLASTNOTIFICATION() != null)
			user.setLastNotificationDate(ConversionUtils.parseDate(profile
					.getBODY().getCONFIGURATION().getRECOMMENDATION()
					.getLASTNOTIFICATION()));

		for (String id : ids) {
			user.getRecommendations().add(id);
		}

		// documents
		if (profile.getBODY().getCONFIGURATION().getDOCUMENTS() != null) {

			List<String> documentIds = profile.getBODY().getCONFIGURATION()
					.getDOCUMENTS().getDOCUMENTID();

			List<String> docIDs = new ArrayList<String>();
			for (String docId : documentIds)
				docIDs.add(docId);
			user.setDocumentIds(docIDs);
			
		}

		// userSTORE
		if (profile.getBODY().getCONFIGURATION().getUSERSTORE() != null) {

			user.setStore(new UserStore());
			user.getStore().setStoreServiceURL(
					profile.getBODY().getCONFIGURATION().getUSERSTORE()
							.getServiceURL());
			user.getStore().setStoreID(
					profile.getBODY().getCONFIGURATION().getUSERSTORE()
							.getStoreID());

		}

		// communities
		if (profile.getBODY().getCONFIGURATION().getCOMMUNITIES() != null) {
			List<COMMUNITYREGISTRATIONType> communities = profile.getBODY()
					.getCONFIGURATION().getCOMMUNITIES()
					.getCOMMUNITYREGISTRATION();
			for (COMMUNITYREGISTRATIONType reg : communities) {
				CommunityRegistration comReg = new CommunityRegistration();

				comReg.setAlertOnChange(reg.isAlertOnChange());
				comReg.setCommunityId(reg.getCommunityId());
				comReg.setIncludeInQueries(reg.isInsertInQueries());

				user.getCommunities().add(comReg);
			}
		}

		if (profile.getBODY().getCONFIGURATION().getFILTER() != null
				&& profile.getBODY().getCONFIGURATION().getFILTER().getQuery()
						.getQuery().getCQL().getValue() != null) {

			logger.debug("create filter for user");

			FILTERType filter = profile.getBODY().getCONFIGURATION()
					.getFILTER();
			SavedQuery sQuery = new SavedQuery();

			sQuery.setCqlText(filter.getQuery().getQuery().getCQL().getValue());
			logger.debug("SQL TEXT:" + sQuery.getCqlText());

			sQuery.setHashValues(new ArrayList<String>());
			sQuery.getHashValues().addAll(filter.getQuery().getHashValue());

			sQuery.setAlertOnChange(filter.getQuery().isAlertOnChange());

			if (filter.getQuery().getQuery().getREFINE() != null)
				sQuery.setRefineText(filter.getQuery().getQuery().getREFINE()
						.getValue());

			if (filter.getQuery().getQuery().getCOLLECTIONID() != null) {

				List<COLLECTIONID> collectionsIds = filter.getQuery()
						.getQuery().getCOLLECTIONID();
				for (COLLECTIONID col : collectionsIds) {
					sQuery.getCollectionIds().add(col.getCollectionId());
				}
			}

			if (filter.getQuery().getQuery().getCOMMUNITYID() != null) {

				List<COMMUNITYID> communityIds = filter.getQuery().getQuery()
						.getCOMMUNITYID();
				for (COMMUNITYID com : communityIds) {
					sQuery.getCommunityIds().add(com.getCommunityId());
				}
			}
			user.setFilter(sQuery);

		}

		// queries
		List<SAVEDQUERYType> queries = profile.getBODY().getCONFIGURATION()
				.getSAVEDQUERIES();
		for (SAVEDQUERYType squery : queries) {

			SavedQuery savedQuery = new SavedQuery();

			savedQuery.setAlertOnChange(squery.isAlertOnChange());

			savedQuery.setCqlText(squery.getQuery().getCQL().getValue());

			if (squery.getQuery().getREFINE() != null)
				savedQuery.setRefineText(squery.getQuery().getREFINE()
						.getValue());

			if (squery.getQuery().getCOLLECTIONID() != null) {
				List<COLLECTIONID> collectionIds = squery.getQuery()
						.getCOLLECTIONID();
				for (COLLECTIONID col : collectionIds) {
					savedQuery.getCollectionIds().add(col.getCollectionId());
				}
			}

			if (squery.getQuery().getCOMMUNITYID() != null) {
				List<COMMUNITYID> communityIds = squery.getQuery()
						.getCOMMUNITYID();
				for (COMMUNITYID com : communityIds) {
					savedQuery.getCommunityIds().add(com.getCommunityId());
				}
			}

			savedQuery.setHashValues(new ArrayList<String>());
			savedQuery.getHashValues().addAll(squery.getHashValue());

			user.getSavedQueries().add(savedQuery);
		}

		return user;
	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((UserProfileSearchCriteria) criteria);
	}

	public String toXQueryString(UserProfileSearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);
		
		String xQuery = "for $x in collection(\"/db/DRIVER/UserDSResources/UserDSResourceType\") ";
		List<String> predicates = new ArrayList<String>();

		if (criteria.getContains() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/PERSONAL_INFO/EMAIL[contains(lower-case(@value), \""
							+ criteria.getContains().toLowerCase() + "\")]");
		}

		if (criteria.getStartsWith() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/PERSONAL_INFO/EMAIL[starts-with(lower-case(@value), \""
							+ criteria.getStartsWith().toLowerCase() + "\")]");
		}

		if (criteria.getEndsWith() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/PERSONAL_INFO/EMAIL[ends-with(lower-case(@value), \""
							+ criteria.getEndsWith().toLowerCase() + "\")]");
		}

		if (criteria.getEmail() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/PERSONAL_INFO/EMAIL[@value = \""
							+ criteria.getEmail() + "\"]");
		}

		if (criteria.getActivationId() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/PERSONAL_INFO/ACTIVATION_ID[@value = \""
							+ criteria.getActivationId() + "\"]");
		}

		if (criteria.getActive() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/PERSONAL_INFO/ACTIVE[@value = \""
							+ criteria.getActive() + "\"]");
		}
		
		if (criteria.getBelongsToCommunity() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/COMMUNITIES/COMMUNITY_REGISTRATION[@communityId = \""
							+ criteria.getBelongsToCommunity() + "\"]");
		}

		if (criteria.getIdentities().size() > 0) {
			xQuery += ", $sec in collection(\"/db/DRIVER/SecurityProfileDSResources/SecurityProfileDSResourceType\")";
			predicates
					.add(" $sec/RESOURCE_PROFILE/BODY/CONFIGURATION/resourceId = $x/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER/@value ");

			String roles = "( ";
			for (int i = 0; i < criteria.getIdentities().size(); i++) {
				if (i != 0) {
					roles += " or ";
				}
				roles += " $sec/RESOURCE_PROFILE/BODY/CONFIGURATION/identities/text[ends-with(., \""
						+ criteria.getIdentities().get(i) + "\")]";
			}
			roles += " )";
			predicates.add(roles);
		}

		for (CommunityRegistration comReg : criteria.getCommunityRegs()) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/COMMUNITIES/COMMUNITY_REGISTRATION[@communityId=\""
							+ comReg.getCommunityId()
							+ "\"]"
							+ "[@alertOnChange=\""
							+ comReg.isAlertOnChange()
							+ "\"]");
		}

		for (int i = 0; i < predicates.size(); i++) {
			String predicate = predicates.get(i);

			if (i > 0)
				xQuery += " and ";
			else
				xQuery += " where ";

			xQuery += predicate;
		}

		xQuery += " return $x";

		return xQuery;
	}
}