package gr.uoa.di.driver.xml;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.data.MDFormatDataStructure;
import eu.dnetlib.domain.functionality.LayoutField;
import eu.dnetlib.domain.functionality.MDFormatSearchCriteria;
import gr.uoa.di.driver.xml.mdformat.RESOURCEPROFILE;
import gr.uoa.di.driver.xml.mdformat.STATUSType.LAYOUTS.LAYOUT;
import gr.uoa.di.driver.xml.mdformat.STATUSType.LAYOUTS.LAYOUT.FIELDS.FIELD;

public class MDFormatDSXmlConverter extends AbstractConverter<MDFormatDataStructure>implements
		ResourceToXmlConverter<MDFormatDataStructure> {

	static Logger logger = Logger.getLogger(MDFormatDSXmlConverter.class);

	public MDFormatDSXmlConverter() throws JAXBException {
		super(RESOURCEPROFILE.class);
	}

	public String ObjectToXml(MDFormatDataStructure object)
			throws JAXBException {

		throw new UnsupportedOperationException("Only xml to object operation"
				+ " is supported");
	}

	@Override
	public MDFormatDataStructure XmlToObject(String xml) throws JAXBException {
		MDFormatDataStructure mdFormat = new MDFormatDataStructure();

		RESOURCEPROFILE profile = setObjectHeader(xml, mdFormat);
		setObjectBody(mdFormat, profile);

		return mdFormat;
	}

	private RESOURCEPROFILE setObjectHeader(String xml,
			MDFormatDataStructure mdFormat) throws JAXBException {

		RESOURCEPROFILE profile = (RESOURCEPROFILE) this.getUnmarshaller()
				.unmarshal(new ByteArrayInputStream(xml.getBytes()));

		mdFormat
				.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
		mdFormat.setDateOfCreation(this.toDate(profile.getHEADER()
				.getDATEOFCREATION().getValue()));
		mdFormat.setResourceKind(profile.getHEADER().getRESOURCEKIND()
				.getValue());
		mdFormat.setResourceType(profile.getHEADER().getRESOURCETYPE()
				.getValue());

		return profile;
	}

	public Date toDate(XMLGregorianCalendar calendar) {
		return calendar.toGregorianCalendar().getTime();
	}

	private void setObjectBody(MDFormatDataStructure mdFormat,
			RESOURCEPROFILE profile) {

		mdFormat
				.setResourceName(profile.getBODY().getCONFIGURATION().getNAME());

		for (LAYOUT l : profile.getBODY().getSTATUS().getLAYOUTS().getLAYOUT()) {
			List<LayoutField> fields = new ArrayList<LayoutField>();

			for (FIELD f : l.getFIELDS().getFIELD()) {
				LayoutField field = new LayoutField();
				field.setName(f.getName());
				field.setXpath(f.getXpath());
				field.setIndexable(f.isIndexable());
				field.setResult(f.isResult());
				field.setType(f.getType());
				field.setStat(f.isStat());
				if (f.isTokenizable() != null){
					field.setTokenizable(f.isTokenizable());
					
				} else {
					field.setTokenizable(false);
				}
				fields.add(field);
			}

			mdFormat.getLayouts().put(l.getName(), fields);
		}

	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((MDFormatSearchCriteria) criteria);
	}

	@Deprecated
	public String toXQueryString(MDFormatDataStructure exampleInstance) {
		String xQuery = "for $x in collection( \"/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType\" )";
		List<String> predicates = new ArrayList<String>();

		if (exampleInstance != null) {
			if (exampleInstance.getResourceName() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[.=\""
								+ exampleInstance.getResourceName() + "\"]");
			}

			for (int i = 0; i < predicates.size(); i++) {
				String predicate = predicates.get(i);

				if (i > 0)
					xQuery += " and ";
				else
					xQuery += " where ";

				xQuery += predicate;
			}
		}

		xQuery += " return $x";
		logger.debug(xQuery);
		return xQuery;
	}

	public String toXQueryString(MDFormatSearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);
		
		String xQuery = null;

		List<String> predicates = new ArrayList<String>();

		xQuery = "for $x in collection( \"/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType\" )";

		if (criteria.getMDFormatName() != null) {
			predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[.= \""
					+ criteria.getMDFormatName() + "\"]");

		}

		for (int i = 0; i < predicates.size(); i++) {
			String predicate = predicates.get(i);

			if (i > 0)
				xQuery += " and ";
			else
				xQuery += " where ";

			xQuery += predicate;
		}
		xQuery += " return $x";
		logger.debug(xQuery);
		return xQuery;
	}

}
