package gr.uoa.di.driver.enabling.vocabulary;

import java.util.Locale;
import java.util.Map;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.enabling.Vocabulary;

public class ChainVocabularyLoader implements VocabularyLoader{

	private Map<String, VocabularyLoader> vocabularyMap = null;
	private VocabularyLoader defaultVocabularyLoader = null;
	
	private static Logger logger = Logger.getLogger(ChainVocabularyLoader.class);
	
	@Override
	public Vocabulary getVocabulary(String vocabularyName, Locale locale, Locale defaultLocale) {
		logger.debug("loading vocabulary with name " + vocabularyName + " locale " + locale + " default locale " + defaultLocale); 
		
		if (vocabularyName == null)
			return null;
		
		VocabularyLoader loader = vocabularyMap.get(vocabularyName);
		if (loader == null){
			loader = defaultVocabularyLoader;
		}
		
		return loader.getVocabulary(vocabularyName, locale, defaultLocale);
	}

	public Map<String, VocabularyLoader> getVocabularyMap() {
		return vocabularyMap;
	}

	public void setVocabularyMap(Map<String, VocabularyLoader> vocabularyMap) {
		this.vocabularyMap = vocabularyMap;
	}

	public VocabularyLoader getDefaultVocabularyLoader() {
		return defaultVocabularyLoader;
	}

	public void setDefaultVocabularyLoader(VocabularyLoader defaultVocabularyLoader) {
		this.defaultVocabularyLoader = defaultVocabularyLoader;
	}

}
