package gr.uoa.di.driver.app;

import javax.xml.ws.Endpoint;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.tools.registration.ValidatingServiceRegistrationManagerImpl;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import eu.dnetlib.utils.EPRUtils;

/**
 * A service registration manager that sets the epr to the service and also 
 * calls its init() method, after registering it to the IS.
 * 
 * @author antleb
 *
 */
public class InitialiazingServiceRegistrationManager extends ValidatingServiceRegistrationManagerImpl {
	private static Logger logger = Logger.getLogger(InitialiazingServiceRegistrationManager.class);
	private EndpointReferenceBuilder<Endpoint> eprBuilder = null;
	private boolean removeRegistration = true;
	
	public void tick() {
		synchronized (this.getRegistrator()) {
			DriverServiceImpl service = (DriverServiceImpl) this.getService();

			if (getState() == State.REGISTERED && !service.isInititialized()) {
				logger.debug("Service is registered and unitialized. Initializing.");
				
				EPR epr = this.createEPR();
				
				epr.setParameter("serviceId", this.getProfileId());
				service.setServiceEPR(epr);
				
				service.init();
			}
		}	
		
		super.tick();
	}
	
	/**
	 * Removes the service registration from the IS.
	 */
	public void destroy() {
		try {
			if (removeRegistration) {
				logger.debug("Removing service registration");

				this.getRegistrator().getRegistryLocator().getService()
						.deleteProfile(this.getProfileId());
			}
		} catch (ISRegistryException e) {
			logger.error("Error removing service registration", e);
		}
	}

	private EPR createEPR() {
		return EPRUtils.createEPR(this.eprBuilder, this.getEndpoint());
	}

	public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
		return eprBuilder;
	}

	public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
		this.eprBuilder = eprBuilder;
	}

	public boolean isRemoveRegistration() {
		return removeRegistration;
	}

	public void setRemoveRegistration(boolean removeRegistration) {
		this.removeRegistration = removeRegistration;
	}
}