package eu.dnetlib.repos.ehcacher;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

import org.apache.log4j.Logger;

public class EhcacheWrapper<K, V> implements CacheWrapper<K, V> {
	private final String cacheName;
	private final CacheManager cacheManager;
	private Logger logger = Logger.getLogger(EhcacheWrapper.class);
	
	public EhcacheWrapper(String cacheName, CacheManager cacheManager) {
		this.cacheName = cacheName;
		this.cacheManager = cacheManager;
		logger.debug("ehcacheWrapper created with name: " + cacheName + "and cachemanager: " + cacheManager);
//		logger.debug("configuration: " + cacheManager.getActiveConfigurationText());
	}

	public void put(final K key, final V value) {
		getCache().put(new Element(key, value));
	}

	@SuppressWarnings("unchecked")
	public V get(final K key) {
		Element element = getCache().get(key);
		if (element != null) {
			return (V) element.getObjectValue();
		}
		return null;
	}

	public Ehcache getCache() {
		return cacheManager.getEhcache(cacheName);
	}

	public int size() {
		return getCache().getSize();
	}
}
