package eu.dnetlib.repos;

import eu.dnetlib.domain.data.Repository;

import java.util.*;

/**
 * Created by nikonas on 16/2/16.
 */
public class RepoTools {

    protected static Map<String, List<Repository>> splitReposPerCountry(List<Repository> repoList) throws Exception {
        Map<String, List<Repository>> res = new TreeMap<String, List<Repository>>();
        for (Repository repo : repoList) {

            List<Repository> repos;
            if (!repo.getCountryName().isEmpty())
                repos = res.get(repo.getCountryName());
            else
                repos = res.get("Without Country");
            if (repos == null) {
                repos = new ArrayList<Repository>();
                if (!repo.getCountryName().isEmpty())
                    res.put(repo.getCountryName(), repos);
                else
                    res.put("Without Country", repos);
            }

            repos.add(repo);
        }
        return res;
    }

    protected static TreeMap<String, List<Map<String, String>>> splitReposByCountry(List<Repository> repoList) throws Exception {
        TreeMap<String, List<Map<String, String>>> res = new TreeMap<String, List<Map<String, String>>>();
        for (Repository repo : repoList) {

            List<Map<String, String>> repos;
            if (!repo.getCountryName().isEmpty())
                repos = res.get(repo.getCountryName());
            else
                repos = res.get("Without Country");
            if (repos == null) {
                repos = new ArrayList<Map<String, String>>();
                if (!repo.getCountryName().isEmpty())
                    res.put(repo.getCountryName(), repos);
                else
                    res.put("Without Country", repos);
            }

            Map<String, String> rep = new HashMap<String, String>();
            rep.put("name", repo.getOfficialName());
            rep.put("id", repo.getId());
            rep.put("url", repo.getWebsiteUrl());
            rep.put("registered", repo.isRegistered() ? "yes" : "no");
            repos.add(rep);
        }
        return res;
    }

    protected static String getFilterKey(String repoMode) {
        String filterKey = "UNKNOWN";
        if (repoMode.equalsIgnoreCase("opendoar")) {
            filterKey = "openaire____::opendoar";
        } else if (repoMode.equalsIgnoreCase("re3data")) {
            filterKey = "openaire____::re3data";
        } else if (repoMode.equalsIgnoreCase("jour_aggr")) {
            filterKey = "infrastruct_::openaire";
        }
        return filterKey;
    }

    protected static Map<String, String> convertRepoToMap(Repository repo) {
        Map<String, String> rep = new HashMap<String, String>();
        rep.put("name", repo.getOfficialName());
        rep.put("id", repo.getId());
        rep.put("url", repo.getWebsiteUrl());
        rep.put("mode", repo.getDatasourceType());
        rep.put("registered", repo.isRegistered() ? "yes" : "no");
        return rep;
    }

}
