package gr.uoa.di.driver.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import javax.xml.bind.JAXBException;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.Community;
import eu.dnetlib.domain.functionality.CommunitySearchCriteria;
import gr.uoa.di.driver.xml.community.COLLECTIONType;
import gr.uoa.di.driver.xml.community.MANAGERType;
import gr.uoa.di.driver.xml.community.ObjectFactory;
import gr.uoa.di.driver.xml.community.RECOMMENDATIONType;
import gr.uoa.di.driver.xml.community.RESOURCEPROFILE;

public class CommunityXmlConverter extends AbstractConverter<Community> implements
		ResourceToXmlConverter<Community> {

	private ObjectFactory of = new ObjectFactory();

	public CommunityXmlConverter() throws JAXBException {
		super(RESOURCEPROFILE.class);
	}

	public Community XmlToObject(String xml) throws JAXBException {
		Community community = new Community();
		RESOURCEPROFILE profile = (RESOURCEPROFILE) this.getUnmarshaller()
				.unmarshal(new ByteArrayInputStream(xml.getBytes()));

		community.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER()
				.getValue());
		community.setResourceUri(profile.getHEADER().getRESOURCEURI()
				.getValue());
		community.setResourceKind(profile.getHEADER().getRESOURCEKIND()
				.getValue());
		community.setResourceType(profile.getHEADER().getRESOURCETYPE()
				.getValue());
		community.setDateOfCreation(ConversionUtils.parseDate(profile.getHEADER()
				.getDATEOFCREATION().getValue()));
		
		community.setName(profile.getBODY().getCONFIGURATION().getNAME()
				.getValue());
		community.setDescription(profile.getBODY().getCONFIGURATION()
				.getDESCRIPTION().getValue());
		community.setOwner(profile.getBODY().getCONFIGURATION().getOWNER()
				.getValue());

		List<COLLECTIONType> collections = profile.getBODY().getCONFIGURATION()
				.getCOLLECTIONS().getCOLLECTION();
		List<MANAGERType> managers = profile.getBODY().getCONFIGURATION()
				.getMANAGERS().getMANAGER();
		List<RECOMMENDATIONType> recommendations = profile.getBODY()
				.getCONFIGURATION().getRECOMMENDATIONS().getRECOMMENDATION();
		List<String> authDocs = profile.getBODY().getCONFIGURATION()
				.getAuthoritativeDocuments().getAuthoritativeDocument();

		for (COLLECTIONType type : collections) {
			community.getCollections().add(type.getCollection());
		}

		for (MANAGERType type : managers) {
			community.getManagers().add(type.getManager());
		}

		for (RECOMMENDATIONType type : recommendations) {
			community.getRecommendations().add(type.getRecommendation());
		}

		community.setAuthoritativeDocuments(new HashSet<String>(authDocs));

		return community;
	}
	
	public String ObjectToXml(Community community) throws JAXBException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		RESOURCEPROFILE profile = of.createRESOURCEPROFILE();

		profile.setHEADER(of.createHEADERType());
		profile.setBODY(of.createBODYType());

		profile.getHEADER().setRESOURCEIDENTIFIER(of.createRESOURCEIDENTIFIERType());
		profile.getHEADER().setRESOURCEKIND(of.createRESOURCEKINDType());
		profile.getHEADER().setRESOURCETYPE(of.createRESOURCETYPEType());
		profile.getHEADER().setRESOURCEURI(of.createRESOURCEURIType());
		profile.getHEADER().setDATEOFCREATION(of.createDATEOFCREATIONType());

		profile.getHEADER().getRESOURCEKIND().setValue(community.getResourceKind());
		profile.getHEADER().getRESOURCETYPE().setValue(community.getResourceType());
		
		if (community.getDateOfCreation() != null)
			profile.getHEADER().getDATEOFCREATION().setValue(
					ConversionUtils
							.DateToString(community.getDateOfCreation()));
		else
			profile.getHEADER().getDATEOFCREATION().setValue("");

		if (community.getResourceId() != null)
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue(
					community.getResourceId());
		else
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
		
		if (community.getResourceUri() != null)
			profile.getHEADER().getRESOURCEURI().setValue(
					community.getResourceUri());
		else
			profile.getHEADER().getRESOURCEURI().setValue("");
		
		
		
		profile.getBODY().setSECURITYPARAMETERS(
				of.createSECURITYPARAMETERSType());
		profile.getBODY().setCONFIGURATION(of.createCONFIGURATIONType());

		profile.getBODY().setSTATUS("value");
		profile.getBODY().getSECURITYPARAMETERS().setSECURITYPARAMETER(
				"Security Parameters");

		profile.getBODY().getCONFIGURATION().setDESCRIPTION(
				of.createCONFIGURATIONTypeDESCRIPTION());
		profile.getBODY().getCONFIGURATION().getDESCRIPTION().setValue(
				community.getDescription());

		profile.getBODY().getCONFIGURATION().setNAME(
				of.createCONFIGURATIONTypeNAME());
		profile.getBODY().getCONFIGURATION().getNAME().setValue(
				community.getName());

		profile.getBODY().getCONFIGURATION().setOWNER(
				of.createCONFIGURATIONTypeOWNER());
		profile.getBODY().getCONFIGURATION().getOWNER().setValue(
				community.getOwner());

		profile.getBODY().getCONFIGURATION().setCOLLECTIONS(
				of.createCOLLECTIONSType());
		profile.getBODY().getCONFIGURATION().setMANAGERS(
				of.createMANAGERSType());
		profile.getBODY().getCONFIGURATION().setRECOMMENDATIONS(
				of.createRECOMMENDATIONSType());
		profile.getBODY().getCONFIGURATION().setAuthoritativeDocuments(
				of.createAuthoritativeDocumentsType());

		for (String collection : community.getCollections()) {
			COLLECTIONType col = of.createCOLLECTIONType();

			col.setCollection(collection);
			profile.getBODY().getCONFIGURATION().getCOLLECTIONS()
					.getCOLLECTION().add(col);
		}

		for (String manager : community.getManagers()) {
			MANAGERType man = of.createMANAGERType();

			man.setManager(manager);
			profile.getBODY().getCONFIGURATION().getMANAGERS().getMANAGER()
					.add(man);
		}

		for (String recommendation : community.getRecommendations()) {
			RECOMMENDATIONType rec = of.createRECOMMENDATIONType();

			rec.setRecommendation(recommendation);
			profile.getBODY().getCONFIGURATION().getRECOMMENDATIONS()
					.getRECOMMENDATION().add(rec);
		}

		profile.getBODY().getCONFIGURATION().getAuthoritativeDocuments()
				.getAuthoritativeDocument().addAll(
						community.getAuthoritativeDocuments());

		this.getMarshaller().marshal(profile, baos);

		return baos.toString();
	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((CommunitySearchCriteria) criteria);
	}

	/**
	 * Creates an XPath query based on the criteria given.
	 * 
	 * @param criteria
	 *            The criteria...
	 * @return the query...
	 */
	public String toXQueryString(CommunitySearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);
		
		String xQuery = null;
		String predicate = "";

		if (criteria.getContains() != null) {
			predicate = "[contains(lower-case(@value), \""
					+ criteria.getContains().toLowerCase() + "\")]";
		}

		if (criteria.getStartsWith() != null) {
			predicate += "[starts-with(lower-case(@value), \""
					+ criteria.getStartsWith().toLowerCase() + "\")]";
		}

		if (criteria.getEndsWith() != null) {
			predicate += "[ends-with(lower-case(@value), \""
					+ criteria.getEndsWith().toLowerCase() + "\")]";
		}

		xQuery = "for $x in collection(\"/db/DRIVER/CommunityDSResources/CommunityDSResourceType\")";
		if (!predicate.equals("")) {
			xQuery += " where ";
			xQuery += " $x//CONFIGURATION/NAME " + predicate;
		}

		xQuery += " order by $x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME/@value ";
		xQuery += " return $x";

		System.out.println("xquery: " + xQuery);

		return xQuery;
	}

	@Deprecated
	public String toXQueryString(Community exampleInstance) {
		/*
		 * for $x in
		 * collection("/db/DRIVER/CommunityResources/CommunityDataStructure")
		 * where
		 * $x//CONFIGURATION/COLLECTIONS/COLLECTION[@collection="collection1"]
		 * return $x
		 */
		String xQuery = "for $x in collection(\"/db/DRIVER/CommunityDSResources/CommunityDSResourceType\") ";
		List<String> predicates = new ArrayList<String>();

		if (exampleInstance != null) {
			if (exampleInstance.getCommunityId() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER[@value=\""
								+ exampleInstance.getCommunityId() + "\"]");
			}
			if (exampleInstance.getName() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[@value=\""
								+ exampleInstance.getName() + "\"]");
			}
			if (exampleInstance.getDescription() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/DESCRIPTION[@value=\""
								+ exampleInstance.getDescription() + "\"]");
			}
			if (exampleInstance.getOwner() != null) {
				predicates
						.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OWNER[@value=\""
								+ exampleInstance.getOwner() + "\"]");
			}

			// TODO add managers and collections

			for (int i = 0; i < predicates.size(); i++) {
				String predicate = predicates.get(i);

				if (i > 0)
					xQuery += " and ";
				else
					xQuery += " where ";

				xQuery += predicate;
			}
		}

		xQuery += " order by $x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME/@value ";
		xQuery += " return $x";

		return xQuery;
	}
}