package gr.uoa.di.driver.enabling.islookup.cache;

import java.util.Collections;
import java.util.List;

import net.sf.ehcache.constructs.blocking.CacheEntryFactory;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.EPR;
import gr.uoa.di.driver.enabling.islookup.cache.CriteriaCacheKey.Mode;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.driver.util.ServiceLocator;

public class LookUpEntryFactory<D extends DriverResource> implements
		CacheEntryFactory {
	private Logger logger = Logger.getLogger(this.getClass());
	private ServiceLocator<ISLookUpService> lookUpServiceLocator = null;
	private ResultSetFactory rsFactory = null;

	public Object createEntry(Object key) throws Exception {
		Object entry = null;

		if (key instanceof String) {
			entry = this.getById((String) key);
		} else if (key instanceof CriteriaCacheKey) {
			CriteriaCacheKey args = (CriteriaCacheKey) key;
			String XQuery = args.getXQuery();
			Mode mode = args.getMode();
			
			entry = this.getByCriteria(XQuery, mode);
		} else {
			logger.warn("key is not id or query");
			logger.warn("key is: " + key + "(" + key.getClass() + ")");
		}

		return entry;
	}

	private List<String> getByCriteria(String XQuery, Mode mode) throws ISLookUpServiceException {
		List<String> res = null;

		switch (mode) {
		case RS:
			logger.debug("Mode is 'RS'. Performing normal search");
			EPR epr = lookUpServiceLocator.getService().searchProfile(XQuery);
			ResultSet<String> rs = rsFactory.createResultSet(epr);
			
			if (rs.size() > 0)
				res = rs.get(1, rs.size());
			else
				res = Collections.emptyList();
			break;
		case QUICK:
			logger.debug("Mode is 'QUICK'. Performing quick search");
			res = lookUpServiceLocator.getService().quickSearchProfile(XQuery);
			break;
		}

		return res;
	}

	private String getById(String key) throws ISLookUpServiceException {
		return lookUpServiceLocator.getService().getResourceProfile(key);
	}

	public ServiceLocator<ISLookUpService> getLookUpServiceLocator() {
		return lookUpServiceLocator;
	}

	public void setLookUpServiceLocator(
			ServiceLocator<ISLookUpService> lookUpServiceLocator) {
		this.lookUpServiceLocator = lookUpServiceLocator;
	}

	public void setRsFactory(ResultSetFactory rsFactory) {
		this.rsFactory = rsFactory;
	}
}
