package gr.uoa.di.driver.dao;

import java.util.List;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.SearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.ISRegistry;
import gr.uoa.di.driver.enabling.ISRegistryException;

public class GenericISDao<D extends DriverResource> implements GenericDAO<D> {
	private static Logger loggger = Logger.getLogger(GenericISDao.class);
	
	protected ISLookUp<D> lookUp = null;
	protected ISRegistry<D> registry = null;

	public void setLookUp(ISLookUp<D> lookUp) {
		this.lookUp = lookUp;
	}

	public void setRegistry(ISRegistry<D> registry) {
		this.registry = registry;
	}

	public D getById(String id) throws DAOException {
		try {
			return lookUp.getById(id);
		} catch (ISLookUpException ile) {
			throw new DAOException("Error getting object", ile);
		}
	}

	public D save(D entity) throws DAOException {
		D object = null;

		try {
			object = registry.save(entity);
		} catch (ISRegistryException e) {
			throw new DAOException("Error saving profile", e);
		}

		return object;
	}

	public void delete(D entity) throws DAOException {
		try {
			this.registry.delete(entity);
		} catch (ISRegistryException ire) {
			throw new DAOException("Error deleting object", ire);
		}
	}

	public List<D> getAll() throws DAOException {
		try {
			return lookUp.fetch( (SearchCriteria) null);
		} catch (ISLookUpException e) {
			throw new DAOException(e);
		}
	}

	public List<D> search(SearchCriteria criteria) throws DAOException {
		try {
			loggger.debug("Performing search");
			
			return lookUp.fetch(criteria);
		} catch (ISLookUpException e) {
			loggger.error(e);
			throw new DAOException(e);
		}
	}

	public D getUniqueResult(SearchCriteria criteria) throws DAOException {
		List<D> results = null;

		try {
			results = lookUp.performQuickSearch(criteria);
		} catch (ISLookUpException e) {
			throw new DAOException("Error searching", e);
		}

		if (results.size() == 0)
			return null;
		else if (results.size() == 1)
			return results.get(0);
		else
			throw new DAOException("More than one results in query.");
	}
}