package eu.dnetlib.repos.ehcacher;

import java.util.List;
import java.util.Map;

import eu.dnetlib.repos.RepoApiExtended;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.repos.RepoApi;

public class CacheEntryFactoryImpl implements CacheEntryFactory {
	private Logger logger = Logger.getLogger(CacheEntryFactoryImpl.class);
	private Map<String, Repository> repositories = null;
	private RepoApiExtended repoAPI = null;
	
	public Object createEntry(Object key) throws Exception {
        logger.debug("++++++creating entry for key = " + key);
			if (((String)key).equalsIgnoreCase("opendoar")) {
				logger.debug("populating doar list");
				repositories = repoAPI.getRepositoriesAsMap("openaire____::opendoar");
			} else if (((String)key).equalsIgnoreCase("re3data")) {
				logger.debug("populating re3data list");
				repositories = repoAPI.getRepositoriesAsMap("openaire____::re3data");
			} else if (((String)key).equalsIgnoreCase("jour_aggr")) {
				logger.debug("populating jour_aggr list");
				repositories = repoAPI.getRepositoriesAsMap("infrastruct_::openaire");
			}
        return repositories;
    }

	public RepoApi getRepoAPI() {
		return repoAPI;
	}

	public void setRepoAPI(RepoApiExtended repoAPI) {
		this.repoAPI = repoAPI;
	}

}