package eu.dnetlib.repos;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;

import java.util.List;
import java.util.Map;

/**
 * Created by nikonas on 21/1/16.
 */
public interface RepoApiExtended extends RepoApi {

    boolean insertPubFileInterface(String dsId, RepositoryInterface iFace)
            throws Exception;

    boolean updatePubFileInterface(String dsId, RepositoryInterface iFace)
            throws Exception;

    Map<String, Repository> getRepositoriesAsMap(String collectedFrom) throws Exception;

    List<Repository> getRepositories(String collectedFrom)
            throws Exception;

    String getNextScheduledExecution(String mode) throws Exception;

    String getListLatestUpdate(String mode) throws Exception;

    List<Repository> getReposByIds(List<String> datasourceIds) throws Exception;

    void getRepositoryStats(Repository repo) throws Exception;

    String updateRepositoryInformation(Repository repo) throws Exception;

    String deleteRepositoryInterfaces(String dsId,
                                      List<RepositoryInterface> interfaces) throws Exception;

    void deleteRepositoryInterfacesWithoutChecks(String dsId, List<RepositoryInterface> interfaces, String datatype) throws Exception;

    String updateRepositoryInterfaces(String dsId,
                                      List<RepositoryInterface> interfaces,
                                      List<RepositoryInterface> interfacesOld, String datatype,
                                      List<RepositoryInterface> interfacesToRegister) throws Exception;

    RepositoryInterface updateRepositoryInterfaceWithoutChecks(String dsId, RepositoryInterface iFace, String datatype) throws Exception;

    String insertRepositoryInterfaces(String dsId,
                                      List<RepositoryInterface> interfaces,
                                      List<RepositoryInterface> interfacesOld, String datatype,
                                      List<RepositoryInterface> interfacesToRegister) throws Exception;

    RepositoryInterface insertRepositoryInterfaceWithoutChecks(String dsId,
                                                RepositoryInterface iFace, String datatype)
            throws Exception;

    boolean unregisterRepository(Repository repo) throws Exception;

    List<Map<String, String>> getRegisteredReposByOthers(String string);

    List<Map<String, String>> getReposOfUser(String user_mail)
            throws Exception;

}
