package eu.dnetlib.repos;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;

public interface RepoApi {

    Repository getRepository(String id) throws Exception;

    Repository getRepository(String officialName, String id)
            throws Exception;

    String storeRepository(Repository repo, String datatype, List<RepositoryInterface> interfacesToRegister)
            throws Exception;

    String editRepository(Repository repo, String officialNameOld,
                          String idOld, String datatype) throws Exception;

    TreeMap<String, List<Map<String, String>>> getRepositoriesByCountry(
            String collectedFrom) throws Exception;

    Map<String, List<Repository>> getRepositoriesPerCountry(
            String collectedFrom) throws Exception;

    List<Repository> getRepositoriesOfCountry(
            String collectedFrom, String country) throws Exception;

    boolean updateRepositoryInterfaceCompliance(String officialName,
                                                String datasourceId, String interfaceId, String desiredCompliance,
                                                String set, String baseUrl, String oldId) throws Exception;

    List<Repository> getRepos(String user_mail, Boolean repoAdmin) throws Exception;

    boolean repoIsCompliant(String officialName) throws Exception;

    Map<String, String> getRepoCompatibility(String officialName,
                                             String datasourceId) throws Exception;

    List<String> getUrlsOfRepos(String user_mail, Boolean repoAdmin) throws Exception;

}