/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.rulelanguage.visitor;

import eu.dnetlib.data.collective.transformation.rulelanguage.Argument;
import eu.dnetlib.data.collective.transformation.rulelanguage.Condition;
import eu.dnetlib.data.collective.transformation.rulelanguage.IRule;
import eu.dnetlib.data.collective.transformation.rulelanguage.Rules;
import eu.dnetlib.data.collective.transformation.rulelanguage.RulesSet;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyAssign;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyAttribute;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyCondition;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyCopy;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyEmpty;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyImport;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyNs;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyOp;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyPreprocess;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyScript;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMySet;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.Converter;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.FunctionCall;
import eu.dnetlib.data.collective.transformation.rulelanguage.visitor.AbstractVisitor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleLanguageVisitor
extends AbstractVisitor {
    private static final Log log = LogFactory.getLog(RuleLanguageVisitor.class);
    private String scriptName = "";
    private ASTMyScript.SCRIPTTYPE scriptType;
    private Map<String, Set<IRule>> elementMappingRules = new LinkedHashMap<String, Set<IRule>>();
    private Map<String, IRule> variableMappingRules = new LinkedHashMap<String, IRule>();
    private Map<String, IRule> templateMappingRules = new LinkedHashMap<String, IRule>();
    private List<String> importedScriptList = new LinkedList<String>();
    private List<FunctionCall> functionCallList = new LinkedList<FunctionCall>();
    private Map<String, String> namespaceDeclMap = new HashMap<String, String>();
    private List<Map<String, String>> preprocessingMap = new LinkedList<Map<String, String>>();

    public String getScriptName() {
        return this.scriptName;
    }

    public ASTMyScript.SCRIPTTYPE getScriptType() {
        return this.scriptType;
    }

    public Map<String, Set<IRule>> getElementMappingRules() {
        return this.elementMappingRules;
    }

    public Map<String, IRule> getVariableMappingRules() {
        return this.variableMappingRules;
    }

    public Map<String, IRule> getTemplateMappingRules() {
        return this.templateMappingRules;
    }

    public List<FunctionCall> getFunctionCalls() {
        return this.functionCallList;
    }

    public List<String> getImportedScripts() {
        return this.importedScriptList;
    }

    public Map<String, String> getNamespaceDeclarations() {
        return this.namespaceDeclMap;
    }

    public List<Map<String, String>> getPreprocessings() {
        return this.preprocessingMap;
    }

    @Override
    public Object visit(ASTMyAssign node, Object data) {
        String attrValue = "";
        String fieldExprValue = "";
        Rules r = node.getRule();
        if (node.isFieldExpression()) {
            fieldExprValue = node.getFieldExpression();
            if (fieldExprValue.startsWith("xpath:")) {
                fieldExprValue = Converter.getXpathFromXpathExpr(fieldExprValue);
                r.setXpath(fieldExprValue);
            } else if (fieldExprValue.startsWith("$") && !fieldExprValue.startsWith("$job.")) {
                log.debug((Object)("ruleLangVisitor: assign variable:" + fieldExprValue));
                r.setAssignmentVariable(fieldExprValue);
            }
        } else {
            attrValue = node.isAttribute() ? node.getValue() : "value not defined: " + node.getValue();
        }
        r.setConstant(attrValue);
        if (r.getUniqueName().trim().length() > 0) {
            this.addRule(r, r.getUniqueName());
        }
        return null;
    }

    @Override
    public Object visit(ASTMyCopy node, Object data) {
        Rules r = node.getRule();
        r.setTemplateMatch(node.getTemplateMatchName());
        r.getProperties().setProperty("applyTemplateSelectExpression", node.getApplyTemplateSelectExpression());
        r.getProperties().setProperty("copySelectExpression", node.getCopySelectExpression());
        this.addRule(r, r.getUniqueName());
        return null;
    }

    @Override
    public Object visit(ASTMySet aNode, Object aData) {
        log.debug((Object)"called method: RuleLanguageVisitor.visit(ASTMySet)");
        Rules myRule = aNode.getRule();
        if (aNode.isValueExpression()) {
            String exprValue = aNode.getValueExpression();
            if (exprValue.startsWith("xpath:")) {
                exprValue = Converter.getXpathFromXpathExpr(exprValue);
                myRule.setXpath(exprValue);
            } else if (exprValue.startsWith("$") && !exprValue.startsWith("$job.")) {
                log.debug((Object)("ruleLangVisitor: assign variable:" + exprValue));
                myRule.setAssignmentVariable(exprValue);
            }
        }
        List<Rules> rules = aNode.getRules();
        RulesSet set = new RulesSet();
        myRule.setRulesSet(set);
        log.debug((Object)("rulelangvisitor rule name: " + myRule.getUniqueName() + " , hasSet : " + myRule.hasSet()));
        set.getPendingRules().addAll(rules);
        this.addRule(myRule, myRule.getUniqueName());
        return null;
    }

    @Override
    public Object visit(ASTMyEmpty node, Object data) {
        Rules r = node.getRule();
        r.setEmpty(node.isEmpty());
        this.addRule(r, r.getUniqueName());
        return null;
    }

    @Override
    public Object visit(ASTMyOp node, Object data) {
        Rules r = node.getRule();
        r.setFunctionCall(node.createFunctionCall(r.isStatic()));
        this.functionCallList.add(r.getFunctionCall());
        log.debug((Object)("fc name: " + r.getFunctionCall().getExternalFunctionName()));
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASTMyAttribute sn = (ASTMyAttribute)node.jjtGetChild(i);
            Argument arg = null;
            if (sn.getAttributeValue() != null) {
                arg = new Argument(Argument.Type.VALUE, sn.getAttributeValue());
            } else if (sn.getAttributeInputField() != null) {
                arg = sn.getAttributeInputField().startsWith("xpath:") ? new Argument(Argument.Type.INPUTFIELD, Converter.getXpathFromXpathExpr(sn.getAttributeInputField())) : (sn.getAttributeInputField().startsWith("$job.") ? new Argument(Argument.Type.JOBCONST, sn.getAttributeInputField()) : new Argument(Argument.Type.VAR, sn.getAttributeInputField()));
            } else {
                throw new IllegalStateException("Argument with neither value nor inputfield is not allowed.");
            }
            log.debug((Object)("argument: " + arg.getArgument()));
            r.getFunctionCall().addArgument(arg);
        }
        if (r.getFunctionCall().getParameters() != null) {
            Set<String> keys = r.getFunctionCall().getParameters().keySet();
            for (String key : keys) {
                log.debug((Object)("key: " + key + " , value: " + r.getFunctionCall().getParameters().get(key)));
            }
        }
        log.debug((Object)("add rule with declaration: " + r.getRuleDeclaration()));
        this.addRule(r, r.getUniqueName());
        return null;
    }

    @Override
    public Object visit(ASTMyImport node, Object data) {
        this.importedScriptList.add(node.getScriptName());
        return null;
    }

    @Override
    public Object visit(ASTMyNs node, Object data) {
        this.namespaceDeclMap.put(node.getNsPrefix(), node.getNsUri());
        return null;
    }

    @Override
    public Object visit(ASTMyScript node, Object data) {
        this.scriptName = node.getScript();
        this.scriptType = node.getScriptType();
        return null;
    }

    @Override
    public Object visit(ASTMyCondition node, Object data) {
        Condition condition = new Condition();
        if (node.getApplyExpression().length() > 0) {
            String applyExpr = Converter.getXpathFromXpathExpr(node.getApplyExpression());
            condition.setApplyExpression(applyExpr);
        }
        String conditionalExpr = Converter.getXpathFromXpathExpr(node.getConditionalExpression());
        condition.setConditionExpression(conditionalExpr);
        condition.setPrimaryRule(node.getPrimaryRule());
        node.getPrimaryRule().setCondition(condition);
        condition.setSecondaryRule(node.getSecondaryRule());
        node.getSecondaryRule().setCondition(condition);
        return null;
    }

    @Override
    public Object visit(ASTMyPreprocess node, Object data) {
        HashMap<String, String> functionMap = new HashMap<String, String>();
        functionMap.put(node.getFunctionName(), node.getParameter());
        this.preprocessingMap.add(functionMap);
        return null;
    }

    private void addRule(IRule rule, String key) {
        log.debug((Object)("add rule with key: " + key));
        Set<Object> ruleSet = null;
        if (rule.definesVariable()) {
            this.variableMappingRules.put(key, rule);
        } else if (rule.definesTemplate()) {
            this.templateMappingRules.put(key, rule);
        } else {
            if (this.elementMappingRules.containsKey(key)) {
                ruleSet = this.elementMappingRules.get(key);
            } else {
                ruleSet = new LinkedHashSet();
                this.elementMappingRules.put(key, ruleSet);
            }
            ruleSet.add(rule);
        }
    }
}

