/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.rulelanguage.parser;

import eu.dnetlib.data.collective.transformation.rulelanguage.Rules;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.AbstractNode;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.FtScript;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.FtScriptVisitor;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.Converter;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.FunctionCall;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ASTMyOp
extends AbstractNode {
    private boolean isFunGetValue = false;
    private boolean isFunConvert = false;
    private boolean isFunConvertString = false;
    private boolean isFunRegExpr = false;
    private boolean isFunExtract = false;
    private boolean isFunSkipRecord = false;
    private boolean isFunSplit = false;
    private boolean isFunLookup = false;
    private boolean isFunConcat = false;
    private boolean isFunIdentifierExtract = false;
    private boolean doPreprocess = true;
    private String functionName = null;
    private Map<String, String> paramMap = null;
    private List<Rules> rulesList = new LinkedList<Rules>();
    private List<String> concatList = new LinkedList<String>();
    private String externalFunctionName = null;

    public ASTMyOp(int id) {
        super(id);
    }

    public ASTMyOp(FtScript p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(FtScriptVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void getValue(String functionName) {
        this.functionName = functionName;
        this.isFunGetValue = true;
        this.externalFunctionName = "getValue";
        this.paramMap = new LinkedHashMap<String, String>();
        this.paramMap.put("functionName", functionName);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public FunctionCall createFunctionCall(boolean aIsStatic) {
        FunctionCall fc = new FunctionCall(aIsStatic, this.doPreprocess);
        fc.setExternalFunctionName(this.externalFunctionName);
        fc.setParameters(this.paramMap);
        fc.setParamList(this.concatList);
        return fc;
    }

    public boolean isGetValue() {
        return this.isFunGetValue;
    }

    public boolean isConvert() {
        return this.isFunConvert;
    }

    public boolean isConvertString() {
        return this.isConvertString();
    }

    public boolean isRegExpr() {
        return this.isFunRegExpr;
    }

    public boolean isExtract() {
        return this.isFunExtract;
    }

    public boolean isFunSkipRecord() {
        return this.isFunSkipRecord;
    }

    public boolean isFunSplit() {
        return this.isFunSplit;
    }

    public boolean isLookup() {
        return this.isFunLookup;
    }

    public boolean isConcat() {
        return this.isFunConcat;
    }

    public void convert(String inputField, String vocabulary, String defaultPattern, String function) {
        String converterInputField = Converter.getXpathFromXpathExpr(inputField);
        if (Converter.isXpathReturningString(converterInputField)) {
            this.externalFunctionName = "convertString";
            this.isFunConvertString = true;
        } else {
            this.externalFunctionName = "convert";
            this.isFunConvert = true;
        }
        this.doPreprocess = false;
        this.paramMap = new LinkedHashMap<String, String>();
        this.paramMap.put("fieldValue", converterInputField);
        this.paramMap.put("vocabularyName", vocabulary);
        if (defaultPattern.trim().length() > 0) {
            this.paramMap.put("defaultPattern", defaultPattern.substring(defaultPattern.indexOf("\"") + 1, defaultPattern.lastIndexOf("\"")));
        }
        if (function.trim().length() > 0) {
            this.paramMap.put("function", function.substring(function.indexOf("\"") + 1, function.lastIndexOf("\"")));
        }
    }

    public void extract(String feature) {
        this.isFunExtract = true;
        this.externalFunctionName = "extract";
        this.paramMap = new LinkedHashMap<String, String>();
        this.paramMap.put("feature", feature);
    }

    public void regExpr(String inputExpr1, String inputExpr2, String regularExpr) {
        this.isFunRegExpr = true;
        this.externalFunctionName = "regExpr";
        this.doPreprocess = false;
        this.paramMap = new LinkedHashMap<String, String>();
        if (inputExpr1.startsWith("xpath:")) {
            this.paramMap.put("expr1", Converter.getXpathFromXpathExpr(inputExpr1));
        } else {
            this.paramMap.put("expr1", inputExpr1);
        }
        if (inputExpr2.startsWith("xpath:")) {
            this.paramMap.put("expr2", Converter.getXpathFromXpathExpr(inputExpr2));
        } else {
            this.paramMap.put("expr2", inputExpr2);
        }
        String regExpr = regularExpr.substring(regularExpr.indexOf("\"") + 1, regularExpr.lastIndexOf("\""));
        this.paramMap.put("regularExpression", regExpr);
    }

    public void skipRecord() {
        this.isFunSkipRecord = true;
        this.doPreprocess = false;
        this.externalFunctionName = "skipRecord";
        this.paramMap = new LinkedHashMap<String, String>();
    }

    public Map<String, String> getParamMap() {
        return this.paramMap;
    }

    public void split(String inputValue, String elementName, String regularExpr) {
        this.isFunSplit = true;
        this.doPreprocess = false;
        this.externalFunctionName = "split";
        this.paramMap = new LinkedHashMap<String, String>();
        if (inputValue.startsWith("xpath:")) {
            this.paramMap.put("inputExpr", Converter.getXpathFromXpathExpr(inputValue));
        } else {
            this.paramMap.put("inputExpr", inputValue);
        }
        String regExpr = regularExpr.substring(regularExpr.indexOf("\"") + 1, regularExpr.lastIndexOf("\""));
        this.paramMap.put("regExpr", regExpr);
        String elemName = elementName.substring(elementName.indexOf("\"") + 1, elementName.lastIndexOf("\""));
        this.paramMap.put("elementName", elemName);
    }

    public void addRule(Rules aRule) {
        this.rulesList.add(aRule);
    }

    public void lookup(String aExprId, String aExprProperty) {
        this.isFunLookup = true;
        this.doPreprocess = false;
        this.externalFunctionName = "lookup";
        this.paramMap = new LinkedHashMap<String, String>();
        if (aExprId.startsWith("xpath:")) {
            this.paramMap.put("exprIdentifier", Converter.getXpathFromXpathExpr(aExprId));
        } else {
            this.paramMap.put("exprIdentifier", aExprId);
        }
        if (aExprProperty.length() > 0) {
            String exprProperty = aExprProperty.substring(1, aExprProperty.length() - 1);
            this.paramMap.put("exprProperty", exprProperty);
        }
    }

    public void concat() {
        this.isFunConcat = true;
        this.doPreprocess = true;
        this.externalFunctionName = "concat";
    }

    public void addConcat(String aTerm) {
        this.concatList.add(aTerm);
    }

    public void identifierExtract(String aXpathExprJsonString, String aXpathExprInSource, String aRegExpr) {
        this.isFunIdentifierExtract = true;
        this.doPreprocess = false;
        this.externalFunctionName = "identifierExtract";
        this.paramMap = new LinkedHashMap<String, String>();
        if (aXpathExprInSource.startsWith("xpath:")) {
            this.paramMap.put("xpathExprInputSource", Converter.getXpathFromXpathExpr(aXpathExprInSource));
        } else {
            this.paramMap.put("xpathExprInputSource", aXpathExprInSource);
        }
        this.paramMap.put("xpathExprJson", Converter.getUnquotedString(aXpathExprJsonString));
        this.paramMap.put("regExpr", Converter.getUnquotedString(aRegExpr));
    }

    public boolean isFunIdentifierExtract() {
        return this.isFunIdentifierExtract;
    }
}

