/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.functions;

import eu.dnetlib.common.profile.Resource;
import eu.dnetlib.common.profile.ResourceDao;
import eu.dnetlib.data.collective.transformation.engine.functions.AbstractTransformationFunction;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import eu.dnetlib.data.collective.transformation.rulelanguage.Argument;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class RetrieveValue
extends AbstractTransformationFunction {
    public static final Log log = LogFactory.getLog(RetrieveValue.class);
    public static final String paramFunctionName = "functionName";
    public static final String paramFunctionProfileId = "functionParameterProfileId";
    public static final String paramFunctionExpr = "functionParameterExpr";
    @javax.annotation.Resource
    private ResourceDao resourceDao;

    @Override
    String execute() throws ProcessingException {
        return null;
    }

    public String executeSingleValue(String functionName, List<Argument> arguments, String objRecord, Map<String, String> namespaceMap) throws ProcessingException {
        String result = "";
        FUNCTION function = FUNCTION.valueOf(functionName);
        switch (function) {
            case PROFILEFIELD: {
                if (arguments.size() != 2) {
                    throw new ProcessingException("invalid number of arguments - required 2 but found :" + arguments.size());
                }
                String arg = "";
                Resource resource = null;
                log.debug((Object)("RETRIEVEVALUE: " + arguments.get(0).getArgument()));
                if (arguments.get(0).isValue()) {
                    arg = arguments.get(0).getArgument();
                    resource = this.resourceDao.getResourceByQuery(arg);
                } else if (arguments.get(0).isInputField()) {
                    arg = this.evaluateXpath(objRecord, arguments.get(0).getArgument(), namespaceMap);
                    if (arg.startsWith("collection(")) {
                        arg = StringEscapeUtils.unescapeXml((String)arg);
                        resource = this.resourceDao.getResourceByQuery(arg);
                    } else {
                        resource = this.resourceDao.getResource(arg);
                    }
                } else if (!arguments.get(0).isJobConst() && arguments.get(0).isVariable()) {
                    log.warn((Object)"RETRIEVEVALUE: support for variables not yet implemented.");
                }
                if (resource == null) {
                    throw new ProcessingException("invalid profileId: " + arg + "; functionName: " + functionName + ", arg1: " + arguments.get(0).getArgument() + ", arg2: " + arguments.get(1).getArgument());
                }
                result = resource.getValue(arguments.get(1).getArgument());
                break;
            }
            case CURRENTDATE: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                result = dateFormat.format(new Date());
            }
        }
        return result;
    }

    public ResourceDao getResourceDao() {
        return this.resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    private String evaluateXpath(String record, String xpathExpr, Map<String, String> nsMap) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if ("dri".equals(prefix)) {
                    return "http://www.driver-repository.eu/namespace/dri";
                }
                if ("dr".equals(prefix)) {
                    return "http://www.driver-repository.eu/namespace/dr";
                }
                if ("dc".equals(prefix)) {
                    return "http://purl.org/dc/elements/1.1/";
                }
                if ("oaf".equals(prefix)) {
                    return "http://namespace.openaire.eu/oaf";
                }
                if ("prov".equals(prefix)) {
                    return "http://www.openarchives.org/OAI/2.0/provenance";
                }
                return "";
            }
        });
        try {
            return xpath.evaluate(xpathExpr, new InputSource(new StringReader(record)));
        }
        catch (XPathExpressionException e) {
            log.fatal((Object)"cannot evaluate xpath");
            throw new IllegalStateException(e);
        }
    }

    public static enum FUNCTION {
        PROFILEFIELD,
        CURRENTDATE;

    }
}

