/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation;

import eu.dnetlib.common.profile.Resource;
import eu.dnetlib.data.collective.transformation.VocabularyMap;
import eu.dnetlib.data.collective.transformation.engine.functions.DateVocabulary;
import eu.dnetlib.data.collective.transformation.engine.functions.IVocabulary;
import eu.dnetlib.data.collective.transformation.engine.functions.PersonVocabulary;
import eu.dnetlib.data.collective.transformation.engine.functions.Vocabulary;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;

public class VocabularyRegistry {
    private static final Log log = LogFactory.getLog(VocabularyRegistry.class);
    private static final String dateVocabularyName = "DateISO8601";
    private static final String personVocabularyName = "Person";
    ServiceLocator<ISLookUpService> lookupLocator;
    private VocabularyMap vocabularies;
    private boolean isInitialized = false;

    public void init() {
        String vocabularyQueryPrefix = "collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')//RESOURCE_PROFILE";
        for (String key : this.vocabularies.getMap().keySet()) {
            try {
                Vocabulary v = this.vocabularies.getMap().get(key);
                v.setResource(new Resource(((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(vocabularyQueryPrefix + "[.//VOCABULARY_NAME='" + this.vocabularies.getMap().get(key).getName() + "']")));
            }
            catch (ISLookUpDocumentNotFoundException e) {
                throw new IllegalStateException("vocabulary profile not found for name " + this.vocabularies.getMap().get(key).getName(), e);
            }
            catch (ISLookUpException e) {
                log.fatal((Object)("ISLookupException in VocabularyRegistry, key = " + key + " : "), (Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (DocumentException e) {
                log.fatal((Object)("DocumentException in VocabularyRegistry, key = " + key + " : "), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        this.vocabularies.getMap().put(dateVocabularyName, new DateVocabulary());
        this.vocabularies.getMap().put(personVocabularyName, new PersonVocabulary());
        this.isInitialized = true;
        log.info((Object)"VocabularyRegistry is initialized.");
    }

    public IVocabulary getVocabulary(String aVocabularyName) {
        if (!this.isInitialized) {
            this.init();
        }
        return this.vocabularies.getMap().get(aVocabularyName);
    }

    public VocabularyMap getVocabularies() {
        if (!this.isInitialized) {
            this.init();
        }
        return this.vocabularies;
    }

    public void setVocabularies(VocabularyMap vocabularies) {
        this.vocabularies = vocabularies;
    }

    public void addVocabulary(String aVocabularyName, Vocabulary aVocabulary) {
        this.vocabularies.getMap().put(aVocabularyName, aVocabulary);
    }

    public void removeVocabulary(String aVocabulary) {
        this.vocabularies.getMap().remove(aVocabulary);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupServiceLocator) {
        this.lookupLocator = lookupServiceLocator;
    }
}

