/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.referenceextraction.dataset.schemas.DocumentToDataSet;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class DocumentToDataSetActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToDataSet> {
    public static final String REL_CLASS_ISRELATEDTO = ResultResultProtos.ResultResult.PublicationDataset.RelName.isRelatedTo.toString();
    private static final AlgorithmName algorithmName = AlgorithmName.document_referencedDatasets;

    @Override
    public ActionBuilderModule<DocumentToDataSet> instantiate(String predefinedTrust, Configuration config) {
        return new DocumentToDataSetActionBuilderModule(predefinedTrust);
    }

    class DocumentToDataSetActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToDataSet> {
        public DocumentToDataSetActionBuilderModule(String predefinedTrust) {
            super(predefinedTrust, algorithmName);
        }

        @Override
        public List<AtomicAction> build(DocumentToDataSet object, Agent agent, String actionSetId) {
            String docId = object.getDocumentId().toString();
            String currentRefId = object.getDatasetId().toString();
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            relBuilder.setChild(false);
            relBuilder.setRelType(RelTypeProtos.RelType.resultResult);
            relBuilder.setSubRelType(RelTypeProtos.SubRelType.publicationDataset);
            relBuilder.setRelClass(REL_CLASS_ISRELATEDTO);
            relBuilder.setSource(docId);
            relBuilder.setTarget(currentRefId);
            ResultResultProtos.ResultResult.Builder resResultBuilder = ResultResultProtos.ResultResult.newBuilder();
            ResultResultProtos.ResultResult.PublicationDataset.Builder pubDatasetBuilder = ResultResultProtos.ResultResult.PublicationDataset.newBuilder();
            pubDatasetBuilder.setRelMetadata(this.buildRelMetadata("dnet:result_result_relations", REL_CLASS_ISRELATEDTO));
            resResultBuilder.setPublicationDataset(pubDatasetBuilder.build());
            relBuilder.setResultResult(resResultBuilder.build());
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(object.getConfidenceLevel() != null ? this.buildInference(object.getConfidenceLevel().floatValue()) : this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            OafProtos.Oaf oaf = oafBuilder.build();
            OafProtos.Oaf oafInverted = this.invertBidirectionalRelationAndBuild(oafBuilder);
            return Arrays.asList(this.actionFactory.createAtomicAction(actionSetId, agent, docId, OafDecoder.decode((OafProtos.Oaf)oaf).getCFQ(), currentRefId, oaf.toByteArray()), this.actionFactory.createAtomicAction(actionSetId, agent, currentRefId, OafDecoder.decode((OafProtos.Oaf)oafInverted).getCFQ(), docId, oafInverted.toByteArray()));
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

