/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.common.citations.schemas.CitationEntry;
import eu.dnetlib.iis.common.model.extrainfo.citations.BlobCitationEntry;
import eu.dnetlib.iis.common.model.extrainfo.citations.TypedId;
import eu.dnetlib.iis.common.model.extrainfo.converter.CitationsExtraInfoConverter;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.export.schemas.Citations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class CitationsActionBuilderModuleFactory
implements ActionBuilderFactory<Citations> {
    private static final String EXTRA_INFO_NAME = "result citations";
    private static final String EXTRA_INFO_TYPOLOGY = "citations";
    private static final AlgorithmName algorithmName = AlgorithmName.document_referencedDocuments;

    @Override
    public ActionBuilderModule<Citations> instantiate(String predefinedTrust, Configuration config) {
        return new CitationActionBuilderModule(predefinedTrust);
    }

    public static BlobCitationEntry build(CitationEntry entry, float confidenceToTrustLevelFactor) {
        BlobCitationEntry result = new BlobCitationEntry(entry.getRawText() != null ? entry.getRawText().toString() : null);
        if (entry.getDestinationDocumentId() != null) {
            result.setIdentifiers(new ArrayList());
            result.getIdentifiers().add(new TypedId(entry.getDestinationDocumentId().toString(), "openaire", entry.getConfidenceLevel() != null ? entry.getConfidenceLevel().floatValue() * confidenceToTrustLevelFactor : 1.0f * confidenceToTrustLevelFactor));
        }
        if (entry.getExternalDestinationDocumentIds() != null && !entry.getExternalDestinationDocumentIds().isEmpty()) {
            if (result.getIdentifiers() == null) {
                result.setIdentifiers(new ArrayList());
            }
            for (Map.Entry extId : entry.getExternalDestinationDocumentIds().entrySet()) {
                result.getIdentifiers().add(new TypedId(((CharSequence)extId.getValue()).toString(), ((CharSequence)extId.getKey()).toString(), 1.0f * confidenceToTrustLevelFactor));
            }
        }
        return result;
    }

    class CitationActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<Citations> {
        CitationsExtraInfoConverter converter;

        public CitationActionBuilderModule(String predefinedTrust) {
            super(predefinedTrust, algorithmName);
            this.converter = new CitationsExtraInfoConverter();
        }

        @Override
        public List<AtomicAction> build(Citations object, Agent agent, String actionSetId) {
            OafProtos.Oaf oaf = this.buildOAFCitations(object);
            if (oaf != null) {
                return this.actionFactory.createUpdateActions(actionSetId, agent, object.getDocumentId().toString(), TypeProtos.Type.result, oaf.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAFCitations(Citations source) {
            if (source.getCitations() != null && source.getCitations().size() > 0) {
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getDocumentId() != null) {
                    entityBuilder.setId(source.getDocumentId().toString());
                }
                FieldTypeProtos.ExtraInfo.Builder extraInfoBuilder = FieldTypeProtos.ExtraInfo.newBuilder();
                extraInfoBuilder.setValue(this.converter.serialize(this.normalize(source.getCitations())));
                extraInfoBuilder.setName(CitationsActionBuilderModuleFactory.EXTRA_INFO_NAME);
                extraInfoBuilder.setTypology(CitationsActionBuilderModuleFactory.EXTRA_INFO_TYPOLOGY);
                extraInfoBuilder.setProvenance(this.inferenceProvenance);
                extraInfoBuilder.setTrust(this.getPredefinedTrust());
                entityBuilder.addExtraInfo(extraInfoBuilder.build());
                entityBuilder.setType(TypeProtos.Type.result);
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        private SortedSet<BlobCitationEntry> normalize(List<CitationEntry> source) {
            if (source != null) {
                TreeSet<BlobCitationEntry> results = new TreeSet<BlobCitationEntry>();
                for (CitationEntry currentEntry : source) {
                    if (currentEntry.getExternalDestinationDocumentIds().isEmpty()) {
                        currentEntry.setExternalDestinationDocumentIds(null);
                    }
                    if (currentEntry.getDestinationDocumentId() != null) {
                        currentEntry.setDestinationDocumentId((CharSequence)StringUtils.split((String)currentEntry.getDestinationDocumentId().toString(), (char)'|')[1]);
                    }
                    results.add(CitationsActionBuilderModuleFactory.build(currentEntry, this.getConfidenceToTrustLevelNormalizationFactor()));
                }
                return results;
            }
            return null;
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

