/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.export.actionmanager.module.toxml.AuthorStatisticsXmlConverter;
import eu.dnetlib.iis.statistics.schemas.AuthorStatistics;
import eu.dnetlib.iis.statistics.schemas.AuthorToAuthorStatistics;
import eu.dnetlib.iis.statistics.schemas.CoAuthor;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class AuthorToAuthorStatisticsActionBuilderModuleFactory
implements ActionBuilderFactory<AuthorToAuthorStatistics> {
    private static final AlgorithmName algorithmName = AlgorithmName.person_statistics;
    private static final String EXTRA_INFO_NAME = "author statistics";
    private static final String EXTRA_INFO_TYPOLOGY = "statistics";

    private AuthorStatistics normalize(AuthorStatistics source) {
        if (source != null && source.getCoAuthors() != null && source.getCoAuthors().size() > 0) {
            for (CoAuthor currentCoAuthor : source.getCoAuthors()) {
                if (currentCoAuthor.getId() == null) continue;
                currentCoAuthor.setId((CharSequence)StringUtils.split((String)currentCoAuthor.getId().toString(), (char)'|')[1]);
            }
        }
        return source;
    }

    @Override
    public ActionBuilderModule<AuthorToAuthorStatistics> instantiate(String predefinedTrust, Configuration config) {
        return new AuthorToAuthorStatisticsActionBuilderModule(predefinedTrust);
    }

    class AuthorToAuthorStatisticsActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<AuthorToAuthorStatistics> {
        AuthorStatisticsXmlConverter converter;

        private AuthorToAuthorStatisticsActionBuilderModule(String predefinedTrust) {
            super(predefinedTrust, algorithmName);
            this.converter = new AuthorStatisticsXmlConverter();
        }

        @Override
        public List<AtomicAction> build(AuthorToAuthorStatistics object, Agent agent, String actionSetId) {
            OafProtos.Oaf oafObject = this.buildOAF(object);
            if (oafObject != null) {
                return this.actionFactory.createUpdateActions(actionSetId, agent, object.getAuthorId().toString(), TypeProtos.Type.person, oafObject.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAF(AuthorToAuthorStatistics source) {
            if (source.getStatistics() != null) {
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getAuthorId() != null) {
                    entityBuilder.setId(source.getAuthorId().toString());
                }
                FieldTypeProtos.ExtraInfo.Builder extraInfoBuilder = FieldTypeProtos.ExtraInfo.newBuilder();
                extraInfoBuilder.setValue(this.converter.serialize(AuthorToAuthorStatisticsActionBuilderModuleFactory.this.normalize(source.getStatistics())));
                extraInfoBuilder.setName(AuthorToAuthorStatisticsActionBuilderModuleFactory.EXTRA_INFO_NAME);
                extraInfoBuilder.setTypology(AuthorToAuthorStatisticsActionBuilderModuleFactory.EXTRA_INFO_TYPOLOGY);
                extraInfoBuilder.setProvenance(this.inferenceProvenance);
                extraInfoBuilder.setTrust(this.getPredefinedTrust());
                entityBuilder.addExtraInfo(extraInfoBuilder.build());
                entityBuilder.setType(TypeProtos.Type.person);
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

