/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.entity.dataset;

import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.tools.JaxwsServiceResolverImpl;
import eu.dnetlib.iis.common.hbase.HBaseConstants;
import eu.dnetlib.iis.core.java.HadoopContext;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Process;
import eu.dnetlib.iis.core.java.ProcessUtils;
import eu.dnetlib.iis.core.java.io.CloseableIterator;
import eu.dnetlib.iis.core.java.io.DataStore;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.core.java.porttype.AvroPortType;
import eu.dnetlib.iis.core.java.porttype.PortType;
import eu.dnetlib.iis.export.actionmanager.api.HBaseActionManagerServiceFacade;
import eu.dnetlib.iis.export.actionmanager.cfg.StaticConfigurationProvider;
import eu.dnetlib.iis.importer.schemas.DocumentToMDStore;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class DatasetExporterProcess
implements Process {
    private final Logger log = Logger.getLogger(this.getClass());
    private static final String inputPort = "input";
    private static final String datasetIdPrefix;

    public Map<String, PortType> getInputPorts() {
        return DatasetExporterProcess.createInputPorts();
    }

    private static HashMap<String, PortType> createInputPorts() {
        HashMap<String, PortType> inputPorts = new HashMap<String, PortType>();
        inputPorts.put(inputPort, (PortType)new AvroPortType(DocumentToMDStore.SCHEMA$));
        return inputPorts;
    }

    public Map<String, PortType> getOutputPorts() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        String mdStoreLocation = ProcessUtils.getParameterValue((String)"import.datacite.mdstore.service.location", (Configuration)context.getConfiguration(), parameters);
        String actionSetId = ProcessUtils.getParameterValue((String)"export.action.setid", (Configuration)context.getConfiguration(), parameters);
        if (mdStoreLocation == null || "$UNDEFINED$".equals(mdStoreLocation)) {
            throw new InvalidParameterException("unable to export dataset entities to action manager, unknown MDStore service location. Required parameter 'import.datacite.mdstore.service.location' is missing!");
        }
        if (actionSetId == null || "$UNDEFINED$".equals(actionSetId)) {
            throw new RuntimeException("unable to export dataset entities to action manager, no 'export.action.setid' required parameter provided!");
        }
        W3CEndpointReferenceBuilder eprBuilder = new W3CEndpointReferenceBuilder();
        eprBuilder.address(mdStoreLocation);
        eprBuilder.build();
        MDStoreService mdStore = (MDStoreService)new JaxwsServiceResolverImpl().getService(MDStoreService.class, eprBuilder.build());
        CloseableIterator idsIt = DataStore.getReader((FileSystemPath)new FileSystemPath(fs, (Path)portBindings.getInput().get(inputPort)));
        HashMap<String, ClassPathResource> xslts = new HashMap<String, ClassPathResource>();
        String dataciteXSLT = "datacite2actions";
        xslts.put(dataciteXSLT, new ClassPathResource("eu/dnetlib/actionmanager/xslt/datacite2insertActions.xslt"));
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.setXslts(xslts);
        HBaseActionManagerServiceFacade actionManager = new HBaseActionManagerServiceFacade(context.getConfiguration(), parameters);
        StaticConfigurationProvider configProvider = new StaticConfigurationProvider(StaticConfigurationProvider.AGENT_DEFAULT, StaticConfigurationProvider.PROVENANCE_DEFAULT, "0.9", "datacite____");
        HashSet<String> exportedDatasetIds = new HashSet<String>();
        try {
            long timeSplit = System.currentTimeMillis();
            int counter = 0;
            while (idsIt.hasNext()) {
                DocumentToMDStore docToMDStoreId = (DocumentToMDStore)idsIt.next();
                String mdStoreId = docToMDStoreId.getMdStoreId().toString();
                String datasetId = docToMDStoreId.getDocumentId().toString();
                String mdRecordId = DatasetExporterProcess.convertToMDStoreId(datasetId);
                if (exportedDatasetIds.contains(datasetId)) continue;
                try {
                    String mdStoreRecord = mdStore.deliverRecord(mdStoreId, mdRecordId);
                    if (mdStoreRecord == null) continue;
                    actionManager.storeAction(actionFactory.generateInfoPackageAction(dataciteXSLT, actionSetId, configProvider.provideAgent(), Operation.INSERT, mdStoreRecord, configProvider.provideProvenance(), configProvider.provideNamespacePrefix(), configProvider.provideActionTrust()));
                    if (++counter % 10000 == 0) {
                        this.log.warn((Object)("exported " + counter + " datasets in " + (System.currentTimeMillis() - timeSplit) / 1000L + " secs"));
                        timeSplit = System.currentTimeMillis();
                    }
                    exportedDatasetIds.add(datasetId);
                }
                catch (DocumentNotFoundException e) {
                    this.log.error((Object)("mdrecord: " + mdRecordId + " wasn't found in mdstore: " + mdStoreId), (Throwable)e);
                }
                catch (Exception e) {
                    this.log.error((Object)("got exception when trying to retrieve MDStore record for mdstore id " + mdStoreId + ", and document id: " + mdRecordId), (Throwable)e);
                    throw e;
                }
            }
            this.log.warn((Object)("exported " + counter + " datasets in total"));
        }
        finally {
            idsIt.close();
            actionManager.close();
        }
    }

    private static final String convertToMDStoreId(String id) {
        if (id != null) {
            if (id.startsWith(datasetIdPrefix)) {
                return id.substring(datasetIdPrefix.length());
            }
            return id;
        }
        return null;
    }

    static {
        try {
            datasetIdPrefix = new String(HBaseConstants.ROW_PREFIX_RESULT, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

