/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.actionset;

import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.enabling.tools.JaxwsServiceResolverImpl;
import eu.dnetlib.iis.core.java.HadoopContext;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Process;
import eu.dnetlib.iis.core.java.ProcessUtils;
import eu.dnetlib.iis.core.java.porttype.PortType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class ActionSetManagementProcess
implements Process {
    private final Logger log = Logger.getLogger(this.getClass());
    public static final String PARAM_ACTION_MANAGER_SERVICE_LOCATION = "export.actionmanager.service.location";
    public static final String PARAM_ACTION_SET_ID = "export.action.setid";

    public Map<String, PortType> getInputPorts() {
        return Collections.emptyMap();
    }

    public Map<String, PortType> getOutputPorts() {
        return Collections.emptyMap();
    }

    public void run(PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws Exception {
        String actionManagerLocation = ProcessUtils.getParameterValue((String)PARAM_ACTION_MANAGER_SERVICE_LOCATION, (Configuration)context.getConfiguration(), parameters);
        String actionSetId = ProcessUtils.getParameterValue((String)PARAM_ACTION_SET_ID, (Configuration)context.getConfiguration(), parameters);
        if (actionManagerLocation != null && !"$UNDEFINED$".equals(actionManagerLocation) && actionSetId != null) {
            W3CEndpointReferenceBuilder eprBuilder = new W3CEndpointReferenceBuilder();
            eprBuilder.address(actionManagerLocation);
            eprBuilder.build();
            ActionManagerService actionManager = (ActionManagerService)new JaxwsServiceResolverImpl().getService(ActionManagerService.class, eprBuilder.build());
            List sets = actionManager.ListSets();
            boolean foundSet = false;
            if (sets != null) {
                for (ActionManagerSet set : sets) {
                    if (!actionSetId.equals(set.getId())) continue;
                    foundSet = true;
                    break;
                }
            }
            if (!foundSet) {
                ActionManagerSet set = new ActionManagerSet();
                set.setId(actionSetId);
                set.setName(actionSetId);
                set.setImpact(ActionManagerSet.ImpactTypes.ONLY_INSERT);
                String createdId = actionManager.createSet(set);
                this.log.warn((Object)("created action set with external id: " + createdId + "," + "set id/name: " + actionSetId));
            } else {
                this.log.warn((Object)("set " + actionSetId + " was already created"));
            }
        } else {
            this.log.warn((Object)"skipping action set management! Either 'export.actionmanager.service.location' parameter or 'export.action.setid' parameter was not provided!");
        }
    }
}

