/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.vocabularies.publisher.controller;

import eu.dnetlib.vocabularies.publisher.VocabularyNotFoundException;
import eu.dnetlib.vocabularies.publisher.VocabularyRetriever;
import eu.dnetlib.vocabularies.publisher.model.Vocabulary;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class VocabularyPublisherController {
    private static final Log log = LogFactory.getLog(VocabularyPublisherController.class);
    @Resource
    private VocabularyRetriever vocabularyRetriever;
    @Value(value="${vocabulary.publisher.title}")
    private String title;
    @Value(value="${vocabulary.publisher.baseURL}")
    private String baseURL;
    @Value(value="${container.context}")
    private String context;

    @RequestMapping(value={"/vocabularies"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Vocabulary> listVocabularies() {
        log.debug((Object)"listVocabularies()");
        return this.vocabularyRetriever.listVocabularies();
    }

    @RequestMapping(value={"/vocabularies/{code}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Vocabulary getVocabulary(@PathVariable(value="code") String code) throws VocabularyNotFoundException {
        log.debug((Object)("getVocabulary with code = " + code));
        return this.vocabularyRetriever.getVocabularyByCode(code);
    }

    @RequestMapping(value={"/vocabularies"}, method={RequestMethod.GET}, produces={"text/html"})
    public void listVocabularies(ModelMap map) {
        map.addAttribute("vocabularies", this.listVocabularies());
        map.addAttribute("title", (Object)this.title);
        map.addAttribute("baseURL", (Object)this.baseURL);
        map.addAttribute("context", (Object)this.context);
    }

    @RequestMapping(value={"/vocabularies/{code}"}, method={RequestMethod.GET}, produces={"text/html"})
    public String getVocabulary(@PathVariable(value="code") String code, ModelMap map) throws VocabularyNotFoundException {
        map.addAttribute("vocabulary", (Object)this.getVocabulary(code));
        map.addAttribute("baseURL", (Object)this.baseURL);
        map.addAttribute("context", (Object)this.context);
        return "displayVocabulary";
    }
}

