/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.vocabularies.publisher;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;
import eu.dnetlib.vocabularies.publisher.VocabularyNotFoundException;
import eu.dnetlib.vocabularies.publisher.model.Vocabulary;
import eu.dnetlib.vocabularies.publisher.model.VocabularyTerm;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;

public class VocabularyRetriever {
    private static final Log log = LogFactory.getLog(VocabularyRetriever.class);
    @Autowired
    private SplittedQueryExecutor queryExecutor;

    @Cacheable(value={"vocabularies"})
    public List<Vocabulary> listVocabularies() {
        log.debug((Object)"listVocabularies(): not using cache");
        String query = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') order by $x//VOCABULARY_NAME return concat ($x//RESOURCE_IDENTIFIER/@value, ':-:',$x//VOCABULARY_NAME, ':-:',$x//VOCABULARY_DESCRIPTION, ':-:',$x//VOCABULARY_NAME/@code)";
        Iterable vocs = this.queryExecutor.query(Vocabulary.class, query);
        return Lists.newArrayList((Iterable)vocs);
    }

    @Cacheable(value={"terms"}, key="#id")
    public Vocabulary getVocabulary(String id) throws VocabularyNotFoundException {
        log.debug((Object)"getVocabulary(): not using cache");
        String queryVoc = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='" + id + "']" + " return concat ($x//RESOURCE_IDENTIFIER/@value, ':-:',$x//VOCABULARY_NAME, ':-:',$x//VOCABULARY_DESCRIPTION, ':-:',$x//VOCABULARY_NAME/@code)";
        Vocabulary voc = this.getVocabularyByQuery(queryVoc);
        if (voc == null) {
            throw new VocabularyNotFoundException("Can't find vocabulary by id: " + id);
        }
        return voc;
    }

    @Cacheable(value={"termsByCode"}, key="#code")
    public Vocabulary getVocabularyByCode(String code) throws VocabularyNotFoundException {
        log.debug((Object)"getVocabularyByCode(): not using cache");
        String queryVoc = "let $x := //RESOURCE_PROFILE[.//VOCABULARY_NAME/@code='" + code + "']" + " return concat ($x//RESOURCE_IDENTIFIER/@value, ':-:',$x//VOCABULARY_NAME, ':-:',$x//VOCABULARY_DESCRIPTION, ':-:',$x//VOCABULARY_NAME/@code)";
        Vocabulary voc = this.getVocabularyByQuery(queryVoc);
        if (voc == null) {
            throw new VocabularyNotFoundException("Can't find vocabulary by code: " + code);
        }
        return voc;
    }

    private Vocabulary getVocabularyByQuery(String query) {
        Iterable vocs = this.queryExecutor.query(Vocabulary.class, query);
        if (vocs.iterator().hasNext()) {
            Vocabulary theVoc = (Vocabulary)vocs.iterator().next();
            if (theVoc.getId() == null) {
                return null;
            }
            String queryTerms = "for $x in /*[.//RESOURCE_IDENTIFIER/@value='" + theVoc.getId() + "']//TERM order by $x/@english_name " + "return concat ($x/@english_name,':-:',$x/@native_name,':-:',$x/@encoding,':-:',$x/@code)";
            Iterable terms = this.queryExecutor.query(VocabularyTerm.class, queryTerms);
            theVoc.setTerms(Lists.newArrayList((Iterable)terms));
            return theVoc;
        }
        return null;
    }
}

