package eu.dnetlib.vocabularies.publisher.model;

import java.io.Serializable;

public class VocabularyTerm implements Serializable {

	private static final long serialVersionUID = -1661921700669896425L;
	private String englishName;
	private String nativeName;
	private String encoding;
	private String code;

	public String getEnglishName() {
		return englishName;
	}

	public void setEnglishName(final String englishName) {
		this.englishName = englishName;
	}

	public String getNativeName() {
		return nativeName;
	}

	public void setNativeName(final String nativeName) {
		this.nativeName = nativeName;
	}

	public String getEncoding() {
		return encoding;
	}

	public void setEncoding(final String encoding) {
		this.encoding = encoding;
	}

	public String getCode() {
		return code;
	}

	public void setCode(final String code) {
		this.code = code;
	}

	public VocabularyTerm() {
		super();
	}

	/**
	 * This constructor is used by the SplittedQueryExecutor for the retrieval of terms from the IS when called by Vocabularyretriever.
	 * 
	 * @param englishName
	 * @param nativeName
	 * @param encoding
	 * @param code
	 */
	public VocabularyTerm(final String englishName, final String nativeName, final String encoding, final String code) {
		super();
		this.englishName = englishName;
		this.nativeName = nativeName;
		this.encoding = encoding;
		this.code = code;
	}

	@Override
	public String toString() {
		return "VocabularyTerm [englishName=" + englishName + ", nativeName=" + nativeName + ", encoding=" + encoding + ", code=" + code + "]";
	}

}
