package eu.dnetlib.vocabularies.publisher.model;

import java.io.Serializable;
import java.util.List;

import com.google.common.collect.Lists;

public class Vocabulary implements Serializable {

	private static final long serialVersionUID = -3859714205200699845L;
	private String id;
	private String name;
	private String description;
	private String code;

	private List<VocabularyTerm> terms;

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public String getCode() {
		return code;
	}

	public void setCode(final String code) {
		this.code = code;
	}

	public List<VocabularyTerm> getTerms() {
		return terms;
	}

	public void setTerms(final List<VocabularyTerm> terms) {
		this.terms = terms;
	}

	public Vocabulary() {
		super();
	}

	public Vocabulary(final String id, final String name, final String description, final String code, final List<VocabularyTerm> terms) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.code = code;
		this.terms = terms;
	}

	public Vocabulary(final String id, final String name, final String description, final String code) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.code = code;
		this.terms = Lists.newArrayList();
	}

	@Override
	public String toString() {
		return "Vocabulary [id=" + id + ", name=" + name + ", description=" + description + ", code=" + code + ", terms=" + terms + "]";
	}

}
