package eu.dnetlib.vocabularies.publisher.controller;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import eu.dnetlib.vocabularies.publisher.VocabularyNotFoundException;

@ControllerAdvice
public class VocabularyExceptionController {

	@ResponseStatus(HttpStatus.NOT_FOUND)
	@ExceptionHandler(VocabularyNotFoundException.class)
	public ModelAndView exception(final VocabularyNotFoundException e) {

		ModelAndView mav = new ModelAndView("error");
		mav.addObject("message", e.getMessage());
		return mav;
	}
}
