/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.validation;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatorServiceBlackboardJobNode
extends BlackboardJobNode
implements ProgressJobNode,
ProgressProvider {
    public static final Log log = LogFactory.getLog(ValidatorServiceBlackboardJobNode.class);
    public static final String VALIDATE_ACTION = "VALIDATE";
    public static final String VALIDATION_TYPE = "DNET";
    public static final String VALIDATOR_EPR_PARAM_NAME = "outputResultSetEpr";
    private String xQueryForValidatorServiceId;
    private String outputEprName = "outputResultSetEpr";
    private String datasourceIDEnvParam;
    private String datasourceNameEnvParam;
    private String interfaceIDEnvParam;
    private String mdstoreId;
    private String guidelines;
    private String blacklistGuidelines;
    private String recordsSampleSize;
    private String extraParams;
    private boolean shouldOutputRecords = false;
    private boolean shouldUpdateBlacklist = true;
    @Resource
    private UniqueServiceLocator serviceLocator;
    private int jobStatusUpdateInterval = 1000;
    private String currentlyValidatedParam = "recordsTested";
    private int currentlyValidated = 0;
    private int total = 0;
    private boolean accurate;

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        String baseUrl;
        job.setAction(VALIDATE_ACTION);
        job.getParameters().put("type", VALIDATION_TYPE);
        job.getParameters().put("guidelines", this.guidelines);
        job.getParameters().put("datasourceId", token.getFullEnv().getAttribute(this.datasourceIDEnvParam));
        String datasourceName = token.getFullEnv().getAttribute(this.datasourceNameEnvParam);
        if (StringUtils.isNotBlank((String)datasourceName)) {
            job.getParameters().put("datasourceName", datasourceName);
        }
        job.getParameters().put("interfaceId", token.getFullEnv().getAttribute(this.interfaceIDEnvParam));
        job.getParameters().put("mdstoreId", this.mdstoreId);
        String nsPrefix = token.getEnv().getAttribute("datasourceNamespacePrefix");
        if (StringUtils.isNotBlank((String)nsPrefix)) {
            job.getParameters().put("datasourceNamespacePrefix", nsPrefix);
        }
        if (StringUtils.isNotBlank((String)(baseUrl = token.getEnv().getAttribute("baseUrl")))) {
            job.getParameters().put("baseUrl", baseUrl);
        }
        if (StringUtils.isNotBlank((String)this.getRecordsSampleSize())) {
            job.getParameters().put("records", this.getRecordsSampleSize());
        }
        this.total = StringUtils.isBlank((String)this.getRecordsSampleSize()) || this.getRecordsSampleSize().equalsIgnoreCase("ALL") ? this.getTotal() : Integer.getInteger(this.getRecordsSampleSize()).intValue();
        job.getParameters().put("outputEpr", this.isShouldOutputRecords() + "");
        job.getParameters().put("blacklistedRecords", this.isShouldUpdateBlacklist() + "");
        if (this.isShouldUpdateBlacklist() && StringUtils.isNotBlank((String)this.blacklistGuidelines)) {
            job.getParameters().put("blacklistGuidelines", this.blacklistGuidelines);
        }
        if (StringUtils.isNotBlank((String)this.extraParams)) {
            job.getParameters().put("extraParams", this.extraParams);
        }
        if (this.jobStatusUpdateInterval > 0) {
            job.getParameters().put("jobStatusUpdateInterval", "" + this.jobStatusUpdateInterval);
        }
        log.debug((Object)"*****Launching validation with the following parameters:****");
        log.debug((Object)("Total records: " + this.total));
        log.debug((Object)("Number of records to validate: " + this.getRecordsSampleSize()));
        log.debug((Object)("jobStatusUpdateInterval (set only if > 0, wf default is 1000, validator's default is 100): " + this.jobStatusUpdateInterval));
        job.getParameters().put("submissionDate", DateUtils.now_ISO8601());
    }

    private int getTotal() {
        int size = -1;
        this.accurate = false;
        try {
            if (StringUtils.isBlank((String)this.getRecordsSampleSize()) || this.getRecordsSampleSize().equalsIgnoreCase("ALL")) {
                size = ((MDStoreService)this.serviceLocator.getService(MDStoreService.class)).size(this.mdstoreId);
                this.accurate = true;
            } else {
                this.total = Integer.parseInt(this.getRecordsSampleSize());
                this.accurate = true;
            }
        }
        catch (MDStoreServiceException e) {
            log.warn((Object)("Can't get size of mdstore " + this.mdstoreId + " progress will be INACCURATE"));
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            log.warn((Object)"The parameter recordSampleSize is invalid: progress will be INACCURATE");
            e.printStackTrace();
        }
        return size;
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, final NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){
            boolean done;
            {
                super(x0, x1);
                this.done = false;
            }

            protected void onDone(BlackboardJob job) {
                if (!ValidatorServiceBlackboardJobNode.this.isShouldOutputRecords()) {
                    log.debug((Object)"If you see this log you are not asking to get the validated EPR...");
                    token.getEnv().setAttribute("validatorJobId", (String)job.getParameters().get("jobId"));
                    String error = (String)job.getParameters().get("error");
                    if (StringUtils.isNotBlank((String)error)) {
                        token.getEnv().setAttribute("validatorError", error);
                    }
                    super.onDone(job);
                }
            }

            protected void onOngoing(BlackboardJob job) {
                ValidatorServiceBlackboardJobNode.this.currentlyValidated = Integer.parseInt((String)job.getParameters().get(ValidatorServiceBlackboardJobNode.this.currentlyValidatedParam));
                if (ValidatorServiceBlackboardJobNode.this.isShouldOutputRecords()) {
                    this.onGoingWithEPRResults(job);
                } else {
                    this.onGoingWithoutEPRResults(job);
                }
            }

            private void onGoingWithEPRResults(BlackboardJob job) {
                if (!this.done) {
                    String epr = (String)job.getParameters().get(ValidatorServiceBlackboardJobNode.VALIDATOR_EPR_PARAM_NAME);
                    log.fatal((Object)("outputResultSetEpr= " + epr));
                    token.getEnv().setAttribute(ValidatorServiceBlackboardJobNode.this.outputEprName, epr);
                    this.done = true;
                    super.onDone(job);
                }
            }

            private void onGoingWithoutEPRResults(BlackboardJob job) {
                super.onOngoing(job);
            }
        };
    }

    protected String obtainServiceId(NodeToken token) {
        try {
            return ((ISLookUpService)this.getServiceLocator().getService(ISLookUpService.class)).getResourceProfileByQuery(this.xQueryForValidatorServiceId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ProgressProvider getProgressProvider() {
        return this;
    }

    public int getTotalValue() {
        return this.total;
    }

    public int getCurrentValue() {
        return this.currentlyValidated;
    }

    public boolean isInaccurate() {
        return !this.accurate;
    }

    public String getGuidelines() {
        return this.guidelines;
    }

    public void setGuidelines(String guidelines) {
        this.guidelines = guidelines;
    }

    public String getRecordsSampleSize() {
        return this.recordsSampleSize;
    }

    public void setRecordsSampleSize(String recordsSampleSize) {
        this.recordsSampleSize = recordsSampleSize;
    }

    public String getMdstoreId() {
        return this.mdstoreId;
    }

    public void setMdstoreId(String mdstoreId) {
        this.mdstoreId = mdstoreId;
    }

    public String getExtra_param() {
        return this.extraParams;
    }

    public void setExtra_param(String extra_param) {
        this.extraParams = extra_param;
    }

    public String getxQueryForValidatorServiceId() {
        return this.xQueryForValidatorServiceId;
    }

    public void setxQueryForValidatorServiceId(String xQueryForValidatorServiceId) {
        this.xQueryForValidatorServiceId = xQueryForValidatorServiceId;
    }

    public String getDatasourceIDEnvParam() {
        return this.datasourceIDEnvParam;
    }

    public void setDatasourceIDEnvParam(String datasourceIDEnvParam) {
        this.datasourceIDEnvParam = datasourceIDEnvParam;
    }

    public String getDatasourceNameEnvParam() {
        return this.datasourceNameEnvParam;
    }

    public void setDatasourceNameEnvParam(String datasourceNameEnvParam) {
        this.datasourceNameEnvParam = datasourceNameEnvParam;
    }

    public String getOutputEprName() {
        return this.outputEprName;
    }

    public void setOutputEprName(String outputEprName) {
        this.outputEprName = outputEprName;
    }

    public String getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(String extraParams) {
        this.extraParams = extraParams;
    }

    public String getCurrentlyValidatedParam() {
        return this.currentlyValidatedParam;
    }

    public void setCurrentlyValidatedParam(String currentlyValidatedParam) {
        this.currentlyValidatedParam = currentlyValidatedParam;
    }

    public int getJobStatusUpdateInterval() {
        return this.jobStatusUpdateInterval;
    }

    public void setJobStatusUpdateInterval(int jobStatusUpdateInterval) {
        this.jobStatusUpdateInterval = jobStatusUpdateInterval;
    }

    public int getCurrentlyValidated() {
        return this.currentlyValidated;
    }

    public void setCurrentlyValidated(int currentlyValidated) {
        this.currentlyValidated = currentlyValidated;
    }

    public boolean isShouldOutputRecords() {
        return this.shouldOutputRecords;
    }

    public void setShouldOutputRecords(boolean shouldOutputRecords) {
        this.shouldOutputRecords = shouldOutputRecords;
    }

    public boolean isShouldUpdateBlacklist() {
        return this.shouldUpdateBlacklist;
    }

    public void setShouldUpdateBlacklist(boolean shouldUpdateBlacklist) {
        this.shouldUpdateBlacklist = shouldUpdateBlacklist;
    }

    public String getInterfaceIDEnvParam() {
        return this.interfaceIDEnvParam;
    }

    public void setInterfaceIDEnvParam(String interfaceIDEnvParam) {
        this.interfaceIDEnvParam = interfaceIDEnvParam;
    }

    public String getBlacklistGuidelines() {
        return this.blacklistGuidelines;
    }

    public void setBlacklistGuidelines(String blacklistGuidelines) {
        this.blacklistGuidelines = blacklistGuidelines;
    }
}

