/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.merge;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class MergeEprsJobNode
extends SimpleJobNode {
    private String inputEprListParam;
    private String outputEprParam;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Resource
    private IterableResultSetFactory iterableResultSetFactory;

    protected String execute(final NodeToken token) throws Exception {
        W3CEndpointReference outputEpr = this.iterableResultSetFactory.createIterableResultSet((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                String[] eprs;
                final ArrayList<Iterator> inputEprIteratorList = new ArrayList<Iterator>();
                for (String epr : eprs = MergeEprsJobNode.this.inputEprListParam.split(",")) {
                    inputEprIteratorList.add(MergeEprsJobNode.this.resultSetClientFactory.getClient(token.getEnv().getAttribute(epr)).iterator());
                }
                return new Iterator<String>(){
                    int roundRobinIndex = 0;

                    @Override
                    public boolean hasNext() {
                        while (inputEprIteratorList.size() > 0) {
                            if (((Iterator)inputEprIteratorList.get(this.roundRobinIndex)).hasNext()) {
                                return true;
                            }
                            inputEprIteratorList.remove(this.roundRobinIndex);
                            if (this.roundRobinIndex < inputEprIteratorList.size()) continue;
                            this.roundRobinIndex = 0;
                        }
                        return false;
                    }

                    @Override
                    public String next() {
                        String next = (String)((Iterator)inputEprIteratorList.get(this.roundRobinIndex)).next();
                        this.roundRobinIndex = (this.roundRobinIndex + 1) % inputEprIteratorList.size();
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
        token.getEnv().setAttribute(this.outputEprParam, outputEpr.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }

    public String getInputEprListParam() {
        return this.inputEprListParam;
    }

    public void setInputEprListParam(String inputEprListParam) {
        this.inputEprListParam = inputEprListParam;
    }
}

