package eu.dnetlib.msro.workflows.nodes.merge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class MergeEprsJobNode extends SimpleJobNode {

	private String inputEprListParam;
	private String outputEprParam;

	@Resource
	private ResultSetClientFactory resultSetClientFactory;

	@Resource
	private IterableResultSetFactory iterableResultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference outputEpr = iterableResultSetFactory.createIterableResultSet(new Iterable<String>() {

			@Override
			public Iterator<String> iterator() {
				// Initialize List of Input iterators
				final List<Iterator<String>> inputEprIteratorList = new ArrayList<Iterator<String>>();
				String[] eprs = inputEprListParam.split(",");
				for (String epr : eprs) {
					inputEprIteratorList.add(resultSetClientFactory.getClient(token.getEnv().getAttribute(epr)).iterator());
				}

				return new Iterator<String>() {

					int roundRobinIndex = 0;

					@Override
					public boolean hasNext() {
						while (inputEprIteratorList.size() > 0) {
							if (inputEprIteratorList.get(roundRobinIndex).hasNext()) return true;
							else {
								inputEprIteratorList.remove(roundRobinIndex);
								if (roundRobinIndex >= inputEprIteratorList.size()) {
									roundRobinIndex = 0;
								}
							}
						}
						return false;
					}

					@Override
					public String next() {
						String next = inputEprIteratorList.get(roundRobinIndex).next();
						roundRobinIndex = (roundRobinIndex + 1) % inputEprIteratorList.size();
						return next;
					}

					@Override
					public void remove() {
						throw new UnsupportedOperationException();
					}
				};
			}
		});

		token.getEnv().setAttribute(outputEprParam, outputEpr.toString());
		return Arc.DEFAULT_ARC;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	public void setResultSetClientFactory(final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

	public IterableResultSetFactory getIterableResultSetFactory() {
		return iterableResultSetFactory;
	}

	public void setIterableResultSetFactory(final IterableResultSetFactory iterableResultSetFactory) {
		this.iterableResultSetFactory = iterableResultSetFactory;
	}

	public String getInputEprListParam() {
		return inputEprListParam;
	}

	public void setInputEprListParam(final String inputEprListParam) {
		this.inputEprListParam = inputEprListParam;
	}

}
