<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:variable name="funderID" select="concat($namespacePrefix, '::FWF')"/>
	<xsl:variable name="fundingName" select="normalize-space(.//column[@name='Grant_Type'])"/>
	<xsl:variable name="fundingCode" select="normalize-space(.//column[@name='Grant_Type_Code'])"/>
	<xsl:variable name="fundingID">
		<xsl:choose>
			<xsl:when test="string-length(normalize-space(.//column[@name='Grant_Type_Code'])) &gt; 0">
				<xsl:value-of select="concat($funderID, '::', normalize-space(.//column[@name='Grant_Type_Code']))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$funderID"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="projectID" select="concat($namespacePrefix, '::', translate(.//column[@name='Project Identifier (Grant)'], ' ', '_'))"/>
	<xsl:variable name="projectCode" select=".//column[@name='Project Identifier (Grant)']"/>
	<xsl:variable name="projectTitle" select=".//column[@name='Grant_Title']"/>

	<xsl:variable name="startDate" select=".//column[@name='Start_date']"/>
	<xsl:variable name="endDate" select=".//column[@name='End_date']"/>

	<xsl:variable name="dateFormat" select="string('dd-MMM-yyyy')"/>

	<xsl:template match="/">
		<record>
			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<xsl:if test="string-length($projectTitle) &gt; 0 and string-length($projectID) &gt; 0">
						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="code">
								<xsl:value-of select=".//column[@name='Project Identifier (Grant)']"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$endDate"/>
							</FIELD>
							<FIELD name="title">
								<xsl:value-of select=".//column[@name='Grant_Title']"/>
							</FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId"/></FIELD>
						</ROW>
						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_">

								<xsl:value-of select="concat($fundingID,'@@', $projectID)"/>
							</FIELD>
							<FIELD name="funding">
								<xsl:value-of select="$fundingID"/>
							</FIELD>
							<FIELD name="project">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$endDate"/>
							</FIELD>
						</ROW>
					</xsl:if>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
