SELECT dor.datasource				as datasource,
		dor.organization			as organization,
 		dor.startdate				as startdate,
 		dor.enddate					as enddate,
 		dor.inferred				as inferred,
		dor.deletedbyinference		as deletedbyinference,
		dor.trust					as trust,
		dor.inferenceprovenance		as inferenceprovenance,
 		
 		doc.code || '@@@' || doc.name || '@@@' || dos.code || '@@@' || dos.name	as semantics,
 		pac.code || '@@@' || pac.name || '@@@' || pas.code || '@@@' || pas.name	as provenanceaction
 		
FROM datasource_organization dor

	left outer join datasources d on (dor.datasource = d.id)

	left outer join class pac on (pac.code = d.provenanceactionclass)
	left outer join scheme pas on (pas.code = d.provenanceactionscheme)

	left outer join class doc on (doc.code = dor.semanticclass)	
	left outer join scheme dos on (dos.code = dor.semanticscheme)
	
--  These clauses have been commented to allow the import of all the datasource on the index 
-- WHERE d.datasourceclass != 'entityregistry'
--	AND d.openairecompatibilityclass IS NOT null
--	AND d.openairecompatibilityclass != 'UNKNOWN'
--	AND d.openairecompatibilityclass != 'notCompatible'
