<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('rcuk________')" />
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::RCUK')" />

	<xsl:template match="/">
		<xsl:variable name="funding" select="//funder/name"/>
			

		<fundingtree>
			<funder>
				<id>
					<xsl:value-of select="$funderID" />
				</id>
				<shortname>RCUK</shortname>
				<name>Research Council UK</name>
				<jurisdiction>GB</jurisdiction>
			</funder>
			<funding_level_0>
				<id>
					<xsl:value-of select="concat($funderID, '::', $funding)" />
				</id>
				<description>
					<xsl:value-of select="$funding" />
				</description>
				<name>
					<xsl:value-of select="$funding" />
				</name>
				<parent></parent>
				<class>rcuk:fundingStream</class>
			</funding_level_0>
		</fundingtree>
	</xsl:template>

</xsl:stylesheet>
