<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs" version="2.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>
	<xsl:param name="quote">"</xsl:param>

	<xsl:variable name="funderID" select="concat($namespacePrefix, '::WT')"/>

	<xsl:variable name="stream" select="normalize-space(.//Grant/Stream)"/>
	<xsl:variable name="fundingID">
		<xsl:choose>
			<xsl:when test="string-length($stream) &gt; 0">
				<xsl:value-of select="concat($funderID, '::', $stream)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$funderID"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="projectID" select="concat($namespacePrefix, '::', .//Grant/Id)"/>

	<xsl:variable name="orgID" select="concat($namespacePrefix, '::', translate(.//Institution/Name, ' ,', '__'))"/>
	<!--
		personID is fine as long as WT gives us one person per project. If they fix their export, we might have 2 persons (or more).
		At this stage we are somehow fine to loose one of the persons (the second project with the same id overwrites the previous project
	 -->
	<xsl:variable name="personID" select="concat($namespacePrefix, '::', .//Person/Alias[@Source='Wellcome Trust'])"/>
	<xsl:variable name="startDate" select="translate(.//Grant/StartDate,'/\','--')"/>
	<xsl:variable name="endDate" select="translate(.//Grant/EndDate,'/\','--')"/>

	<xsl:variable name="dateFormat" select="string('yyyy-MM-dd')"/>

	<xsl:template name="getJson">
		<xsl:param name="varName"/>
		<xsl:param name="value"/>
		<xsl:value-of select="concat($quote, $varName, $quote, ':', $quote, $value, $quote)"/>
	</xsl:template>

	<xsl:template match="/">
		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<xsl:if test="string-length(normalize-space(.//Grant/Title)) &gt; 0 and string-length($projectID) &gt; 0">
						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="code">
								<xsl:value-of select=".//Grant/Id"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$endDate"/>
							</FIELD>
							<FIELD name="title">
								<xsl:value-of select=".//Grant/Title"/>
							</FIELD>
							<FIELD name="contracttypeclass">UNKNOWN</FIELD>
							<FIELD name="contracttypescheme">wt:contractTypes</FIELD>

							<FIELD name="acronym"></FIELD>
							<FIELD name="keywords">
								<xsl:value-of select="normalize-space(.//Grant/Type)"/>
							</FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>
							<FIELD name="optional1">
								<xsl:value-of select="concat(.//Grant/Amount, ' ', .//Grant/Amount/@Currency)"/>
							</FIELD>
							<xsl:if test="string-length(normalize-space(.//Grant/Alias[1]/text())) > 0">
								<xsl:variable name="projectAlias">
									<xsl:call-template name="getJson">
										<xsl:with-param name="varName">alias</xsl:with-param>
										<xsl:with-param name="value">
											<xsl:value-of select=".//Grant/Alias[1]"/>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:variable name="jsonExtra">
									<xsl:value-of select="concat('{', $projectAlias, '}')"/>
								</xsl:variable>
								<FIELD name="jsonextrainfo">
									<xsl:value-of select="$jsonExtra"/>
								</FIELD>
							</xsl:if>
							<!-- oa_mandate_for_publications is true for projects started after 2005 -->
							<xsl:choose>
								<!-- Invalid date: we need at least YYYY -->
								<xsl:when test="string-length($startDate) &lt; 4">
									<FIELD name="oa_mandate_for_publications" type="boolean">false</FIELD>
								</xsl:when>
								<xsl:when test="xs:date($startDate) >= xs:date('2015-01-01')">
									<FIELD name="oa_mandate_for_publications" type="boolean">true</FIELD>
								</xsl:when>
								<xsl:otherwise><FIELD name="oa_mandate_for_publications" type="boolean">false</FIELD></xsl:otherwise>
							</xsl:choose>
						</ROW>

						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($fundingID,'@@', $projectID)"/>
							</FIELD>
							<FIELD name="funding">
								<xsl:value-of select="$fundingID"/>
							</FIELD>
							<FIELD name="project">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$endDate"/>
							</FIELD>
						</ROW>
						<ROW table="persons">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$personID"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$personID"/>
							</FIELD>
							<FIELD name="firstname">
								<xsl:value-of select=".//Person/GivenName"/>
							</FIELD>
							<FIELD name="secondnames">
								<xsl:value-of select=".//Person/FamilyName"/>
							</FIELD>
							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>
							<FIELD name="optional1">
								<xsl:value-of select=".//Person/Title"/>
							</FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						</ROW>
						<xsl:if test="not(concat($namespacePrefix, '::') = $orgID)">
							<ROW table="organizations">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="$orgID"/>
								</FIELD>
								<FIELD name="id">
									<xsl:value-of select="$orgID"/>
								</FIELD>
								<FIELD name="legalname">
									<xsl:value-of select=".//Institution/Name"/>
								</FIELD>
								<FIELD name="collectedfrom">
									<xsl:value-of select="$parentDatasourceId"/>
								</FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
								<FIELD name="trust" type="float">0.8</FIELD>
							</ROW>
							<ROW table="project_organization">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="concat($projectID, '@@', $orgID)"/>
								</FIELD>
								<FIELD name="participantnumber" type="int">1</FIELD>
								<FIELD name="startdate" type="date" format="{$dateFormat}">
									<xsl:value-of select="$startDate"/>
								</FIELD>
								<FIELD name="enddate" type="date" format="{$dateFormat}">
									<xsl:value-of select="$endDate"/>
								</FIELD>
								<FIELD name="project">
									<xsl:value-of select="$projectID"/>
								</FIELD>
								<FIELD name="resporganization">
									<xsl:value-of select="$orgID"/>
								</FIELD>
								<FIELD name="contactperson">
									<xsl:value-of select="$personID"/>
								</FIELD>
								<FIELD name="semanticclass">coordinator</FIELD>
								<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
							</ROW>
						</xsl:if>
					</xsl:if>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>