<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:param name="parentDatasourceId" />
	<xsl:param name="namespacePrefix" select="string('snsf_________')" />
	<xsl:param name="quote">"</xsl:param>

	<xsl:template match="/">
		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<xsl:if test="string-length(normalize-space(.//column[@name='Project Title'])) &gt; 0 and string-length(normalize-space(.//column[@name='Project Number'])) &gt; 0">
						
						<xsl:variable name="projectId" select="concat($namespacePrefix, '::', normalize-space(.//column[@name='Project Number']))" />
						
						<xsl:variable name="orgId" select="concat($namespacePrefix, '::', translate(normalize-space(.//column[@name='Institution']), ' ,.', '___'))" />
						
						<xsl:variable name="startDate" select=".//column[@name='Start Date']"/>
						<xsl:variable name="endDate" select=".//column[@name='End Date']"/>
												
						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="code"><xsl:value-of select="normalize-space(.//column[@name='Project Number String'])"/></FIELD>
							<FIELD name="startdate" type="date" format="dd.MM.yyyy"><xsl:value-of select="$startDate" /></FIELD>
							<FIELD name="enddate" type="date" format="dd.MM.yyyy"><xsl:value-of  select="$endDate"/></FIELD>
							<FIELD name="title"><xsl:value-of select=".//column[@name='Project Title']" /></FIELD>
							<FIELD name="acronym"> </FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<!-- <FIELD name="???"><xsl:value-of select=".//AbstractNarration" /></FIELD> -->
						</ROW>
						
						<ROW table="organizations">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$orgId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$orgId" /></FIELD>
							<FIELD name="legalname"><xsl:value-of select=".//column[@name='Institution']" /></FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="optional1"><xsl:value-of select=".//column[@name='University']" /></FIELD>
						</ROW>					

						<!-- personId built from projectId to handle homonyms -->
						<xsl:variable name="personName" select="normalize-space(.//column[@name='Responsible Applicant'])"/>
						<xsl:variable name="personId" select="concat($projectId, '::', translate($personName, ' ,.', '___'))" />
						
						<xsl:if test="string-length($personName) &gt; 0">
							<ROW table="persons">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$personId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$personId" /></FIELD>
								<FIELD name="firstname"><xsl:value-of select="$personName" /></FIELD>
								<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							</ROW>
						</xsl:if>
	
						<ROW table="project_organization">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectId, '@@', $orgId)" /></FIELD>
							<FIELD name="participantnumber" type="int">1</FIELD>
							<FIELD name="startdate" type="date" format="dd.MM.yyyy"><xsl:value-of select="$startDate" /></FIELD>
							<FIELD name="enddate" type="date" format="dd.MM.yyyy"><xsl:value-of select="$endDate" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="resporganization"><xsl:value-of select="$orgId" /></FIELD>
							<xsl:if test="string-length($personName) &gt; 0">
								<FIELD name="contactperson"><xsl:value-of select="concat($projectId, '::', translate($personName, ' ,.', '___'))" /></FIELD>
							</xsl:if>
							<FIELD name="semanticclass">coordinator</FIELD>
							<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
						</ROW>
						
						<xsl:variable name="p0"	select="normalize-space(.//column[@name='Funding Instrument Hierarchy'])" />
						<xsl:variable name="p1" select="normalize-space(.//column[@name='Funding Instrument'])" />
			
						<xsl:variable name="fundingId">
							<xsl:choose>
								<xsl:when test="(string-length($p0) &gt; 0) and (string-length($p1) &gt; 0)">
									<xsl:value-of select="concat($namespacePrefix, '::SNSF::', $p0, '::', $p1)" />
								</xsl:when>
								<xsl:when test="string-length($p0) &gt; 0">
									<xsl:value-of select="concat($namespacePrefix, '::SNSF::', $p0)" />
								</xsl:when>
								<xsl:when test="string-length($p1) &gt; 0">
									<xsl:value-of select="concat($namespacePrefix, '::SNSF::', $p1)" />
								</xsl:when>
							</xsl:choose>
						</xsl:variable>

						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat(normalize-space($fundingId),'@@', $projectId)" /></FIELD>
							<FIELD name="funding"><xsl:value-of select="normalize-space($fundingId)" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId"/></FIELD>
							<FIELD name="startdate" type="date" format="dd.MM.yyyy"><xsl:value-of select="$startDate"/></FIELD>
							<FIELD name="enddate" type="date" format="dd.MM.yyyy"><xsl:value-of select="$endDate"/></FIELD>
						</ROW>
			
					</xsl:if>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
