<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:output indent="yes" />
	
	<xsl:template match="/">
		<fundings>
			<fundingtree>
				<funder>
					<id>nih_________::NIH</id>
					<shortname>NIH</shortname>
					<name>National Institutes of Health</name>
					<jurisdiction>US</jurisdiction>
				</funder>
			</fundingtree>
			<xsl:for-each select="//IC_NAME[./text() != '']">
				<fundingtree>
					<funder>
						<id>nih_________::NIH</id>
						<shortname>NIH</shortname>
						<name>National Institutes of Health</name>
						<jurisdiction>US</jurisdiction>
					</funder>
					<xsl:variable name="fundingName" select="fn:upper-case(normalize-space(.))"/>
					<funding_level_0>
						<id>
							<!-- remove space -->
							<xsl:value-of select="concat('nih_________::NIH::', $fundingName)" />
						</id>
						<name>
							<xsl:value-of select="$fundingName" />
						</name>
						<description>
							<xsl:value-of select="$fundingName" />
						</description>
						<parent></parent>
						<class>nih:fundingStream</class>
					</funding_level_0>
				</fundingtree>
			</xsl:for-each>
		</fundings>
	</xsl:template>
</xsl:stylesheet>

