package eu.dnetlib.msro.openaireplus.workflows.nodes;

import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import org.springframework.beans.factory.annotation.Required;

public class PrepareIISMainParamsV2JobNode extends PrepareIISParamsV2 {

	private String xqueryObjectStores;

	private String objectStoreParam = "import_content_objectstores_csv";

	private String importHbaseDumpLocation;

	private String importHbaseDumpLocationParam = "import_hbase_dump_location";
	@Override
	protected String execute(final NodeToken token) throws Exception {

		super.prepare(token);

		token.getEnv().setAttribute(getObjectStoreParam(), getFilteredObjectStoreCSV(getXqueryObjectStores()));
		token.getEnv().setAttribute(getImportHbaseDumpLocationParam(), getImportHbaseDumpLocation());

		@SuppressWarnings("unchecked")
		final List<Map<String, String>> sets = new Gson().fromJson(token.getEnv().getAttribute("sets"), List.class);
		for (Map<String, String> set : sets) {
			token.getEnv().setAttribute(set.get("enablingProperty"), set.get("enabled"));
		}

		return Arc.DEFAULT_ARC;
	}

	public String getXqueryObjectStores() {
		return xqueryObjectStores;
	}

	@Required
	public void setXqueryObjectStores(final String xqueryObjectStores) {
		this.xqueryObjectStores = xqueryObjectStores;
	}

	public String getObjectStoreParam() {
		return objectStoreParam;
	}

	public void setObjectStoreParam(final String objectStoreParam) {
		this.objectStoreParam = objectStoreParam;
	}

	public String getImportHbaseDumpLocation() {
		return importHbaseDumpLocation;
	}

	public void setImportHbaseDumpLocation(final String importHbaseDumpLocation) {
		this.importHbaseDumpLocation = importHbaseDumpLocation;
	}

	public String getImportHbaseDumpLocationParam() {
		return importHbaseDumpLocationParam;
	}

	public void setImportHbaseDumpLocationParam(final String importHbaseDumpLocationParam) {
		this.importHbaseDumpLocationParam = importHbaseDumpLocationParam;
	}

}
