<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginalsForPublication"/>
		<ARC to="obtainParams" />
	</ARCS>
</NODE>
<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginalsForPublication"/>
	</ARCS>
</NODE>


<NODE name="fetchOriginalsForPublication" type="FetchMDStoreRecords" isJoin="true">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("harv_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_publication_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="transformPublication"/>
	</ARCS>
</NODE>

<NODE name="transformPublication" type="ApplyXslt">
	<DESCRIPTION>Transform original records to Publication</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="user" function="listFiles('/eu/dnetlib/msro/openaireplus/workflows/repo-hi/xslt-datacite','xsl')"></PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">orig_publication_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">packed_publication_epr</PARAM>		 
	</PARAMETERS>
	<ARCS>
		<ARC to="splitRecords"/>
	</ARCS>
</NODE>

<NODE name="splitRecords" type="SplitDatasetRecord">
	<DESCRIPTION>Split Records into datasets and publication</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParm" managedBy="system">packed_publication_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParm" managedBy="system">publication_epr</PARAM>
	</PARAMETERS>
	<ARCS>		
		<ARC to="findHostedBy"/>
	</ARCS>
</NODE>

<NODE name="findHostedBy" type="FindHostedBy">
	<DESCRIPTION>Patch oaf:hostedBy fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">publication_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">patched_epr</PARAM>
		<PARAM required="true" type="string" name="countersParam" managedBy="system">hostedByCounters</PARAM>	
	</PARAMETERS>
	<ARCS>
		<ARC to="storePublicationRecords"/>
	</ARCS>
</NODE>

<NODE name="storePublicationRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("tranOAF_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">patched_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="validateHostedByRepos"/>
	</ARCS>
</NODE>

<NODE name="validateHostedByRepos" type="UpsertHostedByApis">
	<DESCRIPTION>Validate hostedBy Repos</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="countersParam" managedBy="system">hostedByCounters</PARAM>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tranOAF_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>

