<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('fct_________')" />
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::FCT')" />
	
	<xsl:template match="/">
		<xsl:variable name="p1"	select="normalize-space(.//funding/program)" />
		<xsl:variable name="p2" select="normalize-space(.//funding/program2)" />
				
		<fundingtree>
			<funder>
				<id><xsl:value-of select="$funderID" /></id>
				<shortname>FCT</shortname>
				<name>Fundação para a Ciência e a Tecnologia, I.P.</name>
				<jurisdiction>PT</jurisdiction>
			</funder>
			<xsl:if test="string-length($p1) &gt; 0">
				<xsl:choose>
					<xsl:when test="string-length($p2) &gt; 0">
						<xsl:variable name="level0" select="concat($funderID, '::', $p1)" />
						<xsl:variable name="level1" select="concat($funderID, '::', $p1, '::', $p2)" />
						<funding_level_1>
							<id><xsl:value-of select="$level1" /></id>
							<description><xsl:value-of select="$p2" /></description>
							<name><xsl:value-of select="$p2" /></name>
							<parent>
								<funding_level_0>
									<id><xsl:value-of select="$level0" /></id>
									<description><xsl:value-of select="$p1" /></description>
									<name><xsl:value-of select="$p1" /></name>
									<parent />
									<class>fct:program</class>
								</funding_level_0>
							</parent>
						</funding_level_1>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="level0" select="concat($funderID, '::', $p1)" />
						<funding_level_0>
							<id><xsl:value-of select="$level0" /></id>
							<description><xsl:value-of select="$p1" /></description>
							<name><xsl:value-of select="$p1" /></name>
							<parent />
							<class>fct:program</class>
						</funding_level_0>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</fundingtree>
	</xsl:template>

</xsl:stylesheet>
